/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.RelationExpression;
import tools.mdsd.jamopp.model.java.expressions.RelationExpressionChild;
import tools.mdsd.jamopp.model.java.operators.RelationOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToRelationExpressionConverter
implements Converter<InfixExpression, RelationExpression> {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<InfixExpression.Operator, RelationOperator> toRelationOperatorConverter;

    @Inject
    public ToRelationExpressionConverter(Converter<InfixExpression.Operator, RelationOperator> toRelationOperatorConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory) {
        this.expressionsFactory = expressionsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.toExpressionConverter = toExpressionConverter;
        this.toRelationOperatorConverter = toRelationOperatorConverter;
    }

    @Override
    public RelationExpression convert(InfixExpression expr) {
        RelationExpression result = this.expressionsFactory.createRelationExpression();
        this.mergeRelationExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getLeftOperand()));
        result.getRelationOperators().add((Object)this.toRelationOperatorConverter.convert(expr.getOperator()));
        this.mergeRelationExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getRightOperand()));
        expr.extendedOperands().forEach(obj -> {
            result.getRelationOperators().add((Object)this.toRelationOperatorConverter.convert(expr.getOperator()));
            this.mergeRelationExpressionAndExpression(result, this.toExpressionConverter.convert((Expression)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private void mergeRelationExpressionAndExpression(RelationExpression relExpr, tools.mdsd.jamopp.model.java.expressions.Expression potChild) {
        if (potChild instanceof RelationExpressionChild) {
            relExpr.getChildren().add((Object)((RelationExpressionChild)potChild));
        } else {
            RelationExpression expr = (RelationExpression)potChild;
            relExpr.getChildren().addAll((Collection)expr.getChildren());
            relExpr.getRelationOperators().addAll((Collection)expr.getRelationOperators());
        }
    }
}

