/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.ShiftExpression;
import tools.mdsd.jamopp.model.java.expressions.ShiftExpressionChild;
import tools.mdsd.jamopp.model.java.operators.ShiftOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToShiftExpressionConverter
implements Converter<InfixExpression, ShiftExpression> {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<InfixExpression.Operator, ShiftOperator> toShiftOperatorConverter;

    @Inject
    public ToShiftExpressionConverter(Converter<InfixExpression.Operator, ShiftOperator> toShiftOperatorConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory) {
        this.layoutInformationConverter = layoutInformationConverter;
        this.toExpressionConverter = toExpressionConverter;
        this.toShiftOperatorConverter = toShiftOperatorConverter;
        this.expressionsFactory = expressionsFactory;
    }

    @Override
    public ShiftExpression convert(InfixExpression expr) {
        ShiftExpression result = this.expressionsFactory.createShiftExpression();
        this.mergeShiftExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getLeftOperand()));
        result.getShiftOperators().add((Object)this.toShiftOperatorConverter.convert(expr.getOperator()));
        this.mergeShiftExpressionAndExpression(result, this.toExpressionConverter.convert(expr.getRightOperand()));
        expr.extendedOperands().forEach(obj -> {
            result.getShiftOperators().add((Object)this.toShiftOperatorConverter.convert(expr.getOperator()));
            this.mergeShiftExpressionAndExpression(result, this.toExpressionConverter.convert((Expression)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }

    private void mergeShiftExpressionAndExpression(ShiftExpression shiftExpr, tools.mdsd.jamopp.model.java.expressions.Expression potChild) {
        if (potChild instanceof ShiftExpressionChild) {
            shiftExpr.getChildren().add((Object)((ShiftExpressionChild)potChild));
        } else {
            ShiftExpression expr = (ShiftExpression)potChild;
            shiftExpr.getChildren().addAll((Collection)expr.getChildren());
            shiftExpr.getShiftOperators().addAll((Collection)expr.getShiftOperators());
        }
    }
}

