/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.DefaultSwitchRule;
import tools.mdsd.jamopp.model.java.statements.NormalSwitchCase;
import tools.mdsd.jamopp.model.java.statements.NormalSwitchRule;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.SwitchCase;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToSwitchCaseConverter
implements Converter<org.eclipse.jdt.core.dom.SwitchCase, SwitchCase> {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;

    @Inject
    public ToSwitchCaseConverter(StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
    }

    @Override
    public SwitchCase convert(org.eclipse.jdt.core.dom.SwitchCase switchCase) {
        DefaultSwitchRule result;
        if (switchCase.isSwitchLabeledRule() && switchCase.isDefault()) {
            result = this.statementsFactory.createDefaultSwitchRule();
        } else if (switchCase.isSwitchLabeledRule() && !switchCase.isDefault()) {
            NormalSwitchRule normalRule = this.statementsFactory.createNormalSwitchRule();
            normalRule.setCondition(this.expressionConverterUtility.convert((Expression)switchCase.expressions().get(0)));
            int index = 1;
            while (index < switchCase.expressions().size()) {
                Expression expr = (Expression)switchCase.expressions().get(index);
                normalRule.getAdditionalConditions().add((Object)this.expressionConverterUtility.convert(expr));
                ++index;
            }
            result = normalRule;
        } else if (!switchCase.isSwitchLabeledRule() && switchCase.isDefault()) {
            result = this.statementsFactory.createDefaultSwitchCase();
        } else {
            NormalSwitchCase normalCase = this.statementsFactory.createNormalSwitchCase();
            normalCase.setCondition(this.expressionConverterUtility.convert((Expression)switchCase.expressions().get(0)));
            int index = 1;
            while (index < switchCase.expressions().size()) {
                Expression expr = (Expression)switchCase.expressions().get(index);
                normalCase.getAdditionalConditions().add((Object)this.expressionConverterUtility.convert(expr));
                ++index;
            }
            result = normalCase;
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)switchCase);
        return result;
    }
}

