/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.YieldStatement;
import tools.mdsd.jamopp.model.java.statements.ExpressionStatement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.model.java.statements.SwitchCase;
import tools.mdsd.jamopp.model.java.statements.SwitchRule;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToSwitchCasesAndSetConverter;

public class ToSwitchCasesAndSetConverterImpl
implements ToSwitchCasesAndSetConverter {
    private final StatementsFactory statementsFactory;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<org.eclipse.jdt.core.dom.SwitchCase, SwitchCase> toSwitchCaseConverter;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;

    @Inject
    public ToSwitchCasesAndSetConverterImpl(Converter<org.eclipse.jdt.core.dom.SwitchCase, SwitchCase> toSwitchCaseConverter, StatementsFactory statementsFactory, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter) {
        this.statementsFactory = statementsFactory;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toSwitchCaseConverter = toSwitchCaseConverter;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    public void convert(Switch switchExprSt, List switchStatementList) {
        SwitchCase currentCase = null;
        for (Object element : switchStatementList) {
            Statement statement = (Statement)element;
            if (statement.getNodeType() == 49) {
                currentCase = this.toSwitchCaseConverter.convert((org.eclipse.jdt.core.dom.SwitchCase)statement);
                switchExprSt.getCases().add((Object)currentCase);
                continue;
            }
            if (currentCase instanceof SwitchRule && statement.getNodeType() == 101) {
                YieldStatement yieldStatement = (YieldStatement)statement;
                ExpressionStatement exprSt = this.statementsFactory.createExpressionStatement();
                exprSt.setExpression(this.expressionConverterUtility.convert(yieldStatement.getExpression()));
                currentCase.getStatements().add((Object)exprSt);
                continue;
            }
            if (currentCase == null) continue;
            currentCase.getStatements().add((Object)this.statementToStatementConverter.convert(statement));
        }
    }
}

