/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.UnknownTypeArgument;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilArrays;

public class ToTypeArgumentConverter
implements Converter<ITypeBinding, TypeArgument> {
    private final GenericsFactory genericsFactory;
    private final UtilArrays utilJdtBindingConverter;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;

    @Inject
    public ToTypeArgumentConverter(UtilArrays utilJdtBindingConverter, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, GenericsFactory genericsFactory) {
        this.genericsFactory = genericsFactory;
        this.utilJdtBindingConverter = utilJdtBindingConverter;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
    }

    @Override
    public TypeArgument convert(ITypeBinding binding) {
        UnknownTypeArgument typeArgument;
        if (binding.isWildcardType()) {
            if (binding.getBound() == null) {
                typeArgument = this.genericsFactory.createUnknownTypeArgument();
            } else if (binding.isUpperbound()) {
                ExtendsTypeArgument result = this.genericsFactory.createExtendsTypeArgument();
                result.setExtendType(this.toTypeReferencesConverter.convert(binding.getBound()).get(0));
                this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)result);
                typeArgument = result;
            } else {
                SuperTypeArgument result = this.genericsFactory.createSuperTypeArgument();
                result.setSuperType(this.toTypeReferencesConverter.convert(binding.getBound()).get(0));
                this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)result);
                typeArgument = result;
            }
        } else {
            QualifiedTypeArgument result = this.genericsFactory.createQualifiedTypeArgument();
            result.setTypeReference(this.toTypeReferencesConverter.convert(binding).get(0));
            this.utilJdtBindingConverter.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)result);
            typeArgument = result;
        }
        return typeArgument;
    }
}

