/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.InferableType;
import tools.mdsd.jamopp.model.java.types.NamespaceClassifierReference;
import tools.mdsd.jamopp.model.java.types.PrimitiveType;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilArrays;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToTypeReferenceConverter
implements Converter<Type, TypeReference> {
    private final TypesFactory typesFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilArrays jdtBindingConverterUtility;
    private final Converter<Name, TypeReference> utilBaseConverter;
    private final Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter;
    private final Converter<SimpleName, ClassifierReference> toClassifierReferenceConverter;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;
    private final Provider<Converter<Type, TypeArgument>> typeToTypeArgumentConverter;

    @Inject
    public ToTypeReferenceConverter(Converter<Name, TypeReference> utilBaseConverter, TypesFactory typesFactory, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, Converter<SimpleName, ClassifierReference> toClassifierReferenceConverter, Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter, UtilLayout layoutInformationConverter, UtilArrays jdtBindingConverterUtility, Provider<Converter<Type, TypeArgument>> typeToTypeArgumentConverter) {
        this.typesFactory = typesFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtBindingConverterUtility = jdtBindingConverterUtility;
        this.utilBaseConverter = utilBaseConverter;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
        this.toClassifierReferenceConverter = toClassifierReferenceConverter;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.typeToTypeArgumentConverter = typeToTypeArgumentConverter;
    }

    @Override
    public TypeReference convert(Type type) {
        TypeReference result = null;
        if (type.isPrimitiveType()) {
            result = this.handlePrimitiveType(type);
        } else if (type.isVar()) {
            result = this.handleVar(type);
        } else if (type.isArrayType()) {
            result = this.handleArrayType(type);
        } else if (type.isSimpleType()) {
            result = this.handleSimpleType(type);
        } else if (type.isQualifiedType()) {
            result = this.handleQualifiedType(type);
        } else if (type.isNameQualifiedType()) {
            result = this.handleNameQualifiedType(type);
        } else if (type.isParameterizedType()) {
            result = this.handleParameterizedType(type);
        }
        return result;
    }

    private TypeReference handlePrimitiveType(Type type) {
        org.eclipse.jdt.core.dom.PrimitiveType primType = (org.eclipse.jdt.core.dom.PrimitiveType)type;
        Object convertedType = primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.BOOLEAN) ? this.typesFactory.createBoolean() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.BYTE) ? this.typesFactory.createByte() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.CHAR) ? this.typesFactory.createChar() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.DOUBLE) ? this.typesFactory.createDouble() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.FLOAT) ? this.typesFactory.createFloat() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.INT) ? this.typesFactory.createInt() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.LONG) ? this.typesFactory.createLong() : (primType.getPrimitiveTypeCode().equals(org.eclipse.jdt.core.dom.PrimitiveType.SHORT) ? this.typesFactory.createShort() : this.typesFactory.createVoid())))))));
        primType.annotations().forEach(arg_0 -> this.lambda$0((PrimitiveType)convertedType, arg_0));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)convertedType, (ASTNode)primType);
        return convertedType;
    }

    private TypeReference handleParameterizedType(Type type) {
        ClassifierReference container;
        ParameterizedType paramT = (ParameterizedType)type;
        TypeReference ref = this.convert(paramT.getType());
        if (ref instanceof ClassifierReference) {
            container = (ClassifierReference)ref;
        } else {
            NamespaceClassifierReference containerContainer = (NamespaceClassifierReference)ref;
            container = (ClassifierReference)containerContainer.getClassifierReferences().get(containerContainer.getClassifierReferences().size() - 1);
        }
        paramT.typeArguments().forEach(obj -> {
            boolean bl = container.getTypeArguments().add((Object)((TypeArgument)((Converter)this.typeToTypeArgumentConverter.get()).convert((Type)obj)));
        });
        return ref;
    }

    private TypeReference handleNameQualifiedType(Type type) {
        NamespaceClassifierReference result;
        NameQualifiedType nqT = (NameQualifiedType)type;
        TypeReference parentRef = this.utilBaseConverter.convert(nqT.getQualifier());
        if (parentRef instanceof ClassifierReference) {
            result = this.typesFactory.createNamespaceClassifierReference();
            result.getClassifierReferences().add((Object)((ClassifierReference)parentRef));
        } else {
            result = (NamespaceClassifierReference)parentRef;
        }
        ClassifierReference child = this.toClassifierReferenceConverter.convert(nqT.getName());
        nqT.annotations().forEach(obj -> {
            boolean bl = child.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        result.getClassifierReferences().add((Object)child);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)nqT);
        return result;
    }

    private TypeReference handleQualifiedType(Type type) {
        NamespaceClassifierReference result;
        QualifiedType qualType = (QualifiedType)type;
        TypeReference parentRef = this.convert(qualType.getQualifier());
        if (parentRef instanceof ClassifierReference) {
            result = this.typesFactory.createNamespaceClassifierReference();
            result.getClassifierReferences().add((Object)((ClassifierReference)parentRef));
        } else {
            result = (NamespaceClassifierReference)parentRef;
        }
        ClassifierReference childRef = this.toClassifierReferenceConverter.convert(qualType.getName());
        qualType.annotations().forEach(obj -> {
            boolean bl = childRef.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        result.getClassifierReferences().add((Object)childRef);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)qualType);
        return result;
    }

    private TypeReference handleSimpleType(Type type) {
        TypeReference ref;
        SimpleType simT = (SimpleType)type;
        if (simT.annotations().isEmpty()) {
            ref = this.utilBaseConverter.convert(simT.getName());
        } else {
            ClassifierReference tempRef = this.toClassifierReferenceConverter.convert((SimpleName)simT.getName());
            simT.annotations().forEach(obj -> {
                boolean bl = tempRef.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
            });
            ref = tempRef;
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)ref, (ASTNode)simT);
        return ref;
    }

    private TypeReference handleArrayType(Type type) {
        ArrayType arrT = (ArrayType)type;
        return this.convert(arrT.getElementType());
    }

    private TypeReference handleVar(Type type) {
        InferableType ref = this.typesFactory.createInferableType();
        ITypeBinding binding = type.resolveBinding();
        if (binding != null) {
            ref.getActualTargets().addAll((Collection)this.toTypeReferencesConverter.convert(binding));
            if (binding.isArray()) {
                this.jdtBindingConverterUtility.convertToArrayDimensionsAndSet(binding, (ArrayTypeable)ref);
            } else if (binding.isIntersectionType() && binding.getTypeBounds()[0].isArray()) {
                this.jdtBindingConverterUtility.convertToArrayDimensionsAndSet(binding.getTypeBounds()[0], (ArrayTypeable)ref);
            }
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)ref, (ASTNode)type);
        return ref;
    }

    private /* synthetic */ void lambda$0(PrimitiveType primitiveType, Object obj) {
        boolean bl = primitiveType.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
    }
}

