/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.types.ClassifierReference;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class ToTypeReferencesConverter
implements Converter<ITypeBinding, List<TypeReference>> {
    private final TypesFactory typesFactory;
    private final JdtResolver iUtilJdtResolver;
    private final UtilNamedElement utilNamedElement;
    private final Provider<Converter<ITypeBinding, TypeArgument>> toTypeArgumentConverter;
    private final Map<String, Supplier<TypeReference>> mappings;

    @Inject
    public ToTypeReferencesConverter(TypesFactory typesFactory, UtilNamedElement utilNamedElement, JdtResolver iUtilJdtResolver, Provider<Converter<ITypeBinding, TypeArgument>> toTypeArgumentConverter) {
        this.typesFactory = typesFactory;
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.utilNamedElement = utilNamedElement;
        this.toTypeArgumentConverter = toTypeArgumentConverter;
        this.mappings = new HashMap<String, Supplier<TypeReference>>();
        this.mappings.put("int", () -> typesFactory.createInt());
        this.mappings.put("byte", () -> typesFactory.createByte());
        this.mappings.put("short", () -> typesFactory.createShort());
        this.mappings.put("long", () -> typesFactory.createLong());
        this.mappings.put("boolean", () -> typesFactory.createBoolean());
        this.mappings.put("double", () -> typesFactory.createDouble());
        this.mappings.put("float", () -> typesFactory.createFloat());
        this.mappings.put("void", () -> typesFactory.createVoid());
        this.mappings.put("char", () -> typesFactory.createChar());
    }

    @Override
    public List<TypeReference> convert(ITypeBinding binding) {
        List<TypeReference> list = binding.isPrimitive() ? this.handlePrimitive(binding) : (binding.isArray() ? this.convert(binding.getElementType()) : (binding.isIntersectionType() ? this.handleIntersectionType(binding) : this.handleRest(binding)));
        return list;
    }

    private List<TypeReference> handlePrimitive(ITypeBinding binding) {
        ArrayList<TypeReference> list;
        ArrayList<TypeReference> result = list = new ArrayList<TypeReference>();
        for (Map.Entry<String, Supplier<TypeReference>> entry : this.mappings.entrySet()) {
            if (!entry.getKey().equals(binding.getName())) continue;
            result.add(entry.getValue().get());
            break;
        }
        return list;
    }

    private List<TypeReference> handleRest(ITypeBinding binding) {
        ArrayList<TypeReference> list = new ArrayList<TypeReference>();
        Classifier classifier = this.iUtilJdtResolver.getClassifier(binding);
        this.utilNamedElement.convertToNameAndSet(binding, (NamedElement)classifier);
        ClassifierReference ref = this.typesFactory.createClassifierReference();
        if (binding.isParameterizedType()) {
            ITypeBinding[] iTypeBindingArray = binding.getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding b = iTypeBindingArray[n2];
                ref.getTypeArguments().add((Object)((TypeArgument)((Converter)this.toTypeArgumentConverter.get()).convert(b)));
                ++n2;
            }
        }
        ref.setTarget(classifier);
        list.add((TypeReference)ref);
        return list;
    }

    private List<TypeReference> handleIntersectionType(ITypeBinding binding) {
        ArrayList<TypeReference> list = new ArrayList<TypeReference>();
        ITypeBinding[] iTypeBindingArray = binding.getTypeBounds();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding b = iTypeBindingArray[n2];
            list.addAll(this.convert(b));
            ++n2;
        }
        return list;
    }
}

