/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.UnaryExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryExpressionChild;
import tools.mdsd.jamopp.model.java.operators.UnaryOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ToUnaryExpressionConverter
implements Converter<PrefixExpression, UnaryExpression> {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<PrefixExpression.Operator, UnaryOperator> toUnaryOperatorConverter;

    @Inject
    public ToUnaryExpressionConverter(Converter<PrefixExpression.Operator, UnaryOperator> toUnaryOperatorConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory) {
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionsFactory = expressionsFactory;
        this.toExpressionConverter = toExpressionConverter;
        this.toUnaryOperatorConverter = toUnaryOperatorConverter;
    }

    @Override
    public UnaryExpression convert(PrefixExpression expr) {
        UnaryExpression result = this.expressionsFactory.createUnaryExpression();
        result.getOperators().add((Object)this.toUnaryOperatorConverter.convert(expr.getOperator()));
        tools.mdsd.jamopp.model.java.expressions.Expression potChild = this.toExpressionConverter.convert(expr.getOperand());
        if (potChild instanceof UnaryExpressionChild) {
            result.setChild((UnaryExpressionChild)potChild);
        } else {
            UnaryExpression secRes = (UnaryExpression)potChild;
            result.getOperators().addAll((Collection)secRes.getOperators());
            result.setChild(secRes.getChild());
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }
}

