/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import tools.mdsd.jamopp.model.java.annotations.AnnotationInstance;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.generics.ExtendsTypeArgument;
import tools.mdsd.jamopp.model.java.generics.GenericsFactory;
import tools.mdsd.jamopp.model.java.generics.QualifiedTypeArgument;
import tools.mdsd.jamopp.model.java.generics.SuperTypeArgument;
import tools.mdsd.jamopp.model.java.generics.TypeArgument;
import tools.mdsd.jamopp.model.java.generics.UnknownTypeArgument;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class TypeToTypeArgumentConverter
implements Converter<Type, TypeArgument> {
    private final GenericsFactory genericsFactory;
    private final UtilLayout layoutInformationConverter;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;

    @Inject
    public TypeToTypeArgumentConverter(Converter<Type, TypeReference> toTypeReferenceConverter, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter, Converter<Annotation, AnnotationInstance> toAnnotationInstanceConverter, UtilLayout layoutInformationConverter, GenericsFactory genericsFactory) {
        this.genericsFactory = genericsFactory;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.layoutInformationConverter = layoutInformationConverter;
        this.toAnnotationInstanceConverter = toAnnotationInstanceConverter;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public TypeArgument convert(Type type) {
        TypeArgument result;
        if (type.isWildcardType()) {
            WildcardType wildType = (WildcardType)type;
            if (wildType.getBound() == null) {
                result = this.handleNoBound(wildType);
            } else if (wildType.isUpperBound()) {
                result = this.handleUpperBound(wildType);
            } else {
                SuperTypeArgument newResult = this.genericsFactory.createSuperTypeArgument();
                wildType.annotations().forEach(obj -> {
                    boolean bl = newResult.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
                });
                newResult.setSuperType(this.toTypeReferenceConverter.convert(wildType.getBound()));
                this.utilToArrayDimensionsAndSetConverter.convert(wildType.getBound(), (ArrayTypeable)newResult);
                this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)newResult, (ASTNode)wildType);
                result = newResult;
            }
        } else {
            result = this.handleIsNotWildcard(type);
        }
        return result;
    }

    private TypeArgument handleIsNotWildcard(Type type) {
        QualifiedTypeArgument result = this.genericsFactory.createQualifiedTypeArgument();
        result.setTypeReference(this.toTypeReferenceConverter.convert(type));
        this.utilToArrayDimensionsAndSetConverter.convert(type, (ArrayTypeable)result);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)type);
        return result;
    }

    private TypeArgument handleNoBound(WildcardType wildType) {
        UnknownTypeArgument result = this.genericsFactory.createUnknownTypeArgument();
        wildType.annotations().forEach(obj -> {
            boolean bl = result.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)wildType);
        return result;
    }

    private TypeArgument handleUpperBound(WildcardType wildType) {
        ExtendsTypeArgument result = this.genericsFactory.createExtendsTypeArgument();
        wildType.annotations().forEach(obj -> {
            boolean bl = result.getAnnotations().add((Object)this.toAnnotationInstanceConverter.convert((Annotation)obj));
        });
        result.setExtendType(this.toTypeReferenceConverter.convert(wildType.getBound()));
        this.utilToArrayDimensionsAndSetConverter.convert(wildType.getBound(), (ArrayTypeable)result);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)wildType);
        return result;
    }
}

