/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.AssignmentExpression;
import tools.mdsd.jamopp.model.java.expressions.AssignmentExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.operators.AssignmentOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerAssignment
implements ExpressionHandler {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final Converter<Assignment.Operator, AssignmentOperator> toAssignmentOperatorConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;

    @Inject
    public HandlerAssignment(UtilLayout utilLayout, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, Converter<Assignment.Operator, AssignmentOperator> toAssignmentOperatorConverter, ExpressionsFactory expressionsFactory) {
        this.toAssignmentOperatorConverter = toAssignmentOperatorConverter;
        this.utilLayout = utilLayout;
        this.toExpressionConverter = toExpressionConverter;
        this.expressionsFactory = expressionsFactory;
    }

    @Override
    public tools.mdsd.jamopp.model.java.expressions.Expression handle(Expression expr) {
        Assignment assign = (Assignment)expr;
        AssignmentExpression result = this.expressionsFactory.createAssignmentExpression();
        result.setChild((AssignmentExpressionChild)this.toExpressionConverter.convert(assign.getLeftHandSide()));
        result.setAssignmentOperator(this.toAssignmentOperatorConverter.convert(assign.getOperator()));
        result.setValue(this.toExpressionConverter.convert(assign.getRightHandSide()));
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)expr);
        return result;
    }
}

