/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerCastExpression
implements ExpressionHandler {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;

    @Inject
    public HandlerCastExpression(UtilLayout utilLayout, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, ExpressionsFactory expressionsFactory, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.expressionsFactory = expressionsFactory;
        this.toExpressionConverter = toExpressionConverter;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.utilLayout = utilLayout;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.expressions.Expression handle(Expression expr) {
        CastExpression castExpr = (CastExpression)expr;
        tools.mdsd.jamopp.model.java.expressions.CastExpression result = this.expressionsFactory.createCastExpression();
        if (castExpr.getType().isIntersectionType()) {
            IntersectionType interType = (IntersectionType)castExpr.getType();
            result.setTypeReference(this.toTypeReferenceConverter.convert((Type)interType.types().get(0)));
            this.utilToArrayDimensionsAndSetConverter.convert((Type)interType.types().get(0), (ArrayTypeable)result);
            int index = 1;
            while (index < interType.types().size()) {
                result.getAdditionalBounds().add((Object)this.toTypeReferenceConverter.convert((Type)interType.types().get(index)));
                ++index;
            }
        } else {
            result.setTypeReference(this.toTypeReferenceConverter.convert(castExpr.getType()));
            this.utilToArrayDimensionsAndSetConverter.convert(castExpr.getType(), (ArrayTypeable)result);
        }
        result.setGeneralChild(this.toExpressionConverter.convert(castExpr.getExpression()));
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)castExpr);
        return result;
    }
}

