/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.InfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.AdditiveExpression;
import tools.mdsd.jamopp.model.java.expressions.AndExpression;
import tools.mdsd.jamopp.model.java.expressions.AndExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.ConditionalAndExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalAndExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.ConditionalOrExpression;
import tools.mdsd.jamopp.model.java.expressions.ConditionalOrExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.EqualityExpression;
import tools.mdsd.jamopp.model.java.expressions.ExclusiveOrExpression;
import tools.mdsd.jamopp.model.java.expressions.ExclusiveOrExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.InclusiveOrExpression;
import tools.mdsd.jamopp.model.java.expressions.InclusiveOrExpressionChild;
import tools.mdsd.jamopp.model.java.expressions.MultiplicativeExpression;
import tools.mdsd.jamopp.model.java.expressions.RelationExpression;
import tools.mdsd.jamopp.model.java.expressions.ShiftExpression;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerInfixExpression
implements ExpressionHandler {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Expression> toExpressionConverter;
    private final Map<Function<InfixExpression, Expression>, Set<InfixExpression.Operator>> mapping;

    @Inject
    public HandlerInfixExpression(UtilLayout utilLayout, Converter<InfixExpression, ShiftExpression> toShiftExpressionConverter, Converter<InfixExpression, RelationExpression> toRelationExpressionConverter, Converter<InfixExpression, MultiplicativeExpression> toMultiplicativeExpressionConverter, Converter<org.eclipse.jdt.core.dom.Expression, Expression> toExpressionConverter, Converter<InfixExpression, EqualityExpression> toEqualityExpressionConverter, Converter<InfixExpression, AdditiveExpression> toAdditiveExpressionConverter, ExpressionsFactory expressionsFactory) {
        this.expressionsFactory = expressionsFactory;
        this.toExpressionConverter = toExpressionConverter;
        this.utilLayout = utilLayout;
        this.mapping = new HashMap<Function<InfixExpression, Expression>, Set<InfixExpression.Operator>>();
        this.mapping.put(this::handleConditionalOr, Set.of(InfixExpression.Operator.CONDITIONAL_OR));
        this.mapping.put(this::handleConditionalAnd, Set.of(InfixExpression.Operator.CONDITIONAL_AND));
        this.mapping.put(this::handleOperatorOr, Set.of(InfixExpression.Operator.OR));
        this.mapping.put(this::handleOperatorXor, Set.of(InfixExpression.Operator.XOR));
        this.mapping.put(this::handleOperatorAnd, Set.of(InfixExpression.Operator.AND));
        this.mapping.put(toEqualityExpressionConverter::convert, Set.of(InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS));
        this.mapping.put(toRelationExpressionConverter::convert, Set.of(InfixExpression.Operator.GREATER, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.LESS, InfixExpression.Operator.LESS_EQUALS));
        this.mapping.put(toShiftExpressionConverter::convert, Set.of(InfixExpression.Operator.LEFT_SHIFT, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED));
        this.mapping.put(toAdditiveExpressionConverter::convert, Set.of(InfixExpression.Operator.PLUS, InfixExpression.Operator.MINUS));
        this.mapping.put(toMultiplicativeExpressionConverter::convert, Set.of(InfixExpression.Operator.TIMES, InfixExpression.Operator.DIVIDE, InfixExpression.Operator.REMAINDER));
    }

    @Override
    public Expression handle(org.eclipse.jdt.core.dom.Expression expr) {
        InfixExpression infix = (InfixExpression)expr;
        Expression result = null;
        for (Map.Entry<Function<InfixExpression, Expression>, Set<InfixExpression.Operator>> entry : this.mapping.entrySet()) {
            if (!entry.getValue().contains(infix.getOperator())) continue;
            result = entry.getKey().apply(infix);
            break;
        }
        return result;
    }

    private Expression handleOperatorAnd(InfixExpression infix) {
        AndExpression result;
        Expression expression = this.toExpressionConverter.convert(infix.getLeftOperand());
        if (expression instanceof AndExpression) {
            result = (AndExpression)expression;
        } else {
            result = this.expressionsFactory.createAndExpression();
            result.getChildren().add((Object)((AndExpressionChild)expression));
        }
        result.getChildren().add((Object)((AndExpressionChild)this.toExpressionConverter.convert(infix.getRightOperand())));
        infix.extendedOperands().forEach(obj -> {
            boolean bl = result.getChildren().add((Object)((AndExpressionChild)this.toExpressionConverter.convert((org.eclipse.jdt.core.dom.Expression)obj)));
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)infix);
        return result;
    }

    private Expression handleOperatorXor(InfixExpression infix) {
        ExclusiveOrExpression result;
        Expression expression = this.toExpressionConverter.convert(infix.getLeftOperand());
        if (expression instanceof ExclusiveOrExpression) {
            result = (ExclusiveOrExpression)expression;
        } else {
            result = this.expressionsFactory.createExclusiveOrExpression();
            result.getChildren().add((Object)((ExclusiveOrExpressionChild)expression));
        }
        result.getChildren().add((Object)((ExclusiveOrExpressionChild)this.toExpressionConverter.convert(infix.getRightOperand())));
        infix.extendedOperands().forEach(obj -> {
            boolean bl = result.getChildren().add((Object)((ExclusiveOrExpressionChild)this.toExpressionConverter.convert((org.eclipse.jdt.core.dom.Expression)obj)));
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)infix);
        return result;
    }

    private Expression handleOperatorOr(InfixExpression infix) {
        InclusiveOrExpression result;
        Expression expression = this.toExpressionConverter.convert(infix.getLeftOperand());
        if (expression instanceof InclusiveOrExpression) {
            result = (InclusiveOrExpression)expression;
        } else {
            result = this.expressionsFactory.createInclusiveOrExpression();
            result.getChildren().add((Object)((InclusiveOrExpressionChild)expression));
        }
        result.getChildren().add((Object)((InclusiveOrExpressionChild)this.toExpressionConverter.convert(infix.getRightOperand())));
        infix.extendedOperands().forEach(obj -> {
            boolean bl = result.getChildren().add((Object)((InclusiveOrExpressionChild)this.toExpressionConverter.convert((org.eclipse.jdt.core.dom.Expression)obj)));
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)infix);
        return result;
    }

    private Expression handleConditionalAnd(InfixExpression infix) {
        ConditionalAndExpression result;
        Expression expression = this.toExpressionConverter.convert(infix.getLeftOperand());
        if (expression instanceof ConditionalAndExpression) {
            result = (ConditionalAndExpression)expression;
        } else {
            result = this.expressionsFactory.createConditionalAndExpression();
            result.getChildren().add((Object)((ConditionalAndExpressionChild)expression));
        }
        result.getChildren().add((Object)((ConditionalAndExpressionChild)this.toExpressionConverter.convert(infix.getRightOperand())));
        infix.extendedOperands().forEach(obj -> {
            boolean bl = result.getChildren().add((Object)((ConditionalAndExpressionChild)this.toExpressionConverter.convert((org.eclipse.jdt.core.dom.Expression)obj)));
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)infix);
        return result;
    }

    private Expression handleConditionalOr(InfixExpression infix) {
        ConditionalOrExpression result;
        Expression expression = this.toExpressionConverter.convert(infix.getLeftOperand());
        if (expression instanceof ConditionalOrExpression) {
            result = (ConditionalOrExpression)expression;
        } else {
            result = this.expressionsFactory.createConditionalOrExpression();
            result.getChildren().add((Object)((ConditionalOrExpressionChild)expression));
        }
        result.getChildren().add((Object)((ConditionalOrExpressionChild)this.toExpressionConverter.convert(infix.getRightOperand())));
        infix.extendedOperands().forEach(obj -> {
            boolean bl = result.getChildren().add((Object)((ConditionalOrExpressionChild)this.toExpressionConverter.convert((org.eclipse.jdt.core.dom.Expression)obj)));
        });
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)infix);
        return result;
    }
}

