/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Type;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.InstanceOfExpression;
import tools.mdsd.jamopp.model.java.expressions.InstanceOfExpressionChild;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerInstanceOf
implements ExpressionHandler {
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;

    @Inject
    public HandlerInstanceOf(UtilLayout utilLayout, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, ExpressionsFactory expressionsFactory, ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter) {
        this.utilLayout = utilLayout;
        this.toExpressionConverter = toExpressionConverter;
        this.expressionsFactory = expressionsFactory;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.expressions.Expression handle(Expression expr) {
        InstanceofExpression castedExpr = (InstanceofExpression)expr;
        InstanceOfExpression result = this.expressionsFactory.createInstanceOfExpression();
        result.setChild((InstanceOfExpressionChild)this.toExpressionConverter.convert(castedExpr.getLeftOperand()));
        result.setTypeReference(this.toTypeReferenceConverter.convert(castedExpr.getRightOperand()));
        this.utilToArrayDimensionsAndSetConverter.convert(castedExpr.getRightOperand(), (ArrayTypeable)result);
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)castedExpr);
        return result;
    }
}

