/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExplicitlyTypedLambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.ImplicitlyTypedLambdaParameters;
import tools.mdsd.jamopp.model.java.expressions.LambdaBody;
import tools.mdsd.jamopp.model.java.expressions.LambdaExpression;
import tools.mdsd.jamopp.model.java.expressions.LambdaParameters;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class HandlerLambdaExpression
implements ExpressionHandler {
    private final TypesFactory typesFactory;
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final JdtResolver iUtilJdtResolver;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Expression> toExpressionConverter;
    private final Converter<SingleVariableDeclaration, OrdinaryParameter> toOrdinaryParameterConverter;
    private final Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter;
    private final Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter;

    @Inject
    public HandlerLambdaExpression(UtilLayout utilLayout, JdtResolver iUtilJdtResolver, Converter<SingleVariableDeclaration, OrdinaryParameter> toOrdinaryParameterConverter, Converter<org.eclipse.jdt.core.dom.Expression, Expression> toExpressionConverter, ExpressionsFactory expressionsFactory, TypesFactory typesFactory, Converter<ITypeBinding, List<TypeReference>> toTypeReferencesConverter, Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter) {
        this.typesFactory = typesFactory;
        this.expressionsFactory = expressionsFactory;
        this.toExpressionConverter = toExpressionConverter;
        this.utilLayout = utilLayout;
        this.iUtilJdtResolver = iUtilJdtResolver;
        this.toOrdinaryParameterConverter = toOrdinaryParameterConverter;
        this.toTypeReferencesConverter = toTypeReferencesConverter;
        this.blockToBlockConverter = blockToBlockConverter;
    }

    @Override
    public Expression handle(org.eclipse.jdt.core.dom.Expression expr) {
        org.eclipse.jdt.core.dom.LambdaExpression lambda = (org.eclipse.jdt.core.dom.LambdaExpression)expr;
        LambdaExpression result = this.expressionsFactory.createLambdaExpression();
        if (!lambda.parameters().isEmpty() && lambda.parameters().get(0) instanceof VariableDeclarationFragment) {
            Object param = lambda.hasParentheses() ? this.expressionsFactory.createImplicitlyTypedLambdaParameters() : this.expressionsFactory.createSingleImplicitLambdaParameter();
            lambda.parameters().forEach(arg_0 -> this.lambda$0((ImplicitlyTypedLambdaParameters)param, arg_0));
            result.setParameters((LambdaParameters)param);
        } else {
            ExplicitlyTypedLambdaParameters param = this.expressionsFactory.createExplicitlyTypedLambdaParameters();
            lambda.parameters().forEach(obj -> {
                boolean bl = param.getParameters().add((Object)((Parameter)this.toOrdinaryParameterConverter.convert((SingleVariableDeclaration)obj)));
            });
            result.setParameters((LambdaParameters)param);
        }
        if (lambda.getBody() instanceof org.eclipse.jdt.core.dom.Expression) {
            result.setBody((LambdaBody)this.toExpressionConverter.convert((org.eclipse.jdt.core.dom.Expression)lambda.getBody()));
        } else {
            result.setBody((LambdaBody)this.blockToBlockConverter.convert((Block)lambda.getBody()));
        }
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)lambda);
        return result;
    }

    private /* synthetic */ void lambda$0(ImplicitlyTypedLambdaParameters implicitlyTypedLambdaParameters, Object obj) {
        OrdinaryParameter nextParam;
        VariableDeclarationFragment frag = (VariableDeclarationFragment)obj;
        IVariableBinding binding = frag.resolveBinding();
        if (binding != null) {
            nextParam = this.iUtilJdtResolver.getOrdinaryParameter(binding);
            nextParam.setTypeReference(this.toTypeReferencesConverter.convert(binding.getType()).get(0));
        } else {
            nextParam = this.iUtilJdtResolver.getOrdinaryParameter(String.valueOf(frag.getName().getIdentifier()) + frag.hashCode());
            nextParam.setTypeReference((TypeReference)this.typesFactory.createVoid());
        }
        nextParam.setName(frag.getName().getIdentifier());
        implicitlyTypedLambdaParameters.getParameters().add((Object)nextParam);
    }
}

