/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.SuffixUnaryModificationExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryModificationExpressionChild;
import tools.mdsd.jamopp.model.java.operators.OperatorsFactory;
import tools.mdsd.jamopp.model.java.operators.UnaryModificationOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerPostfixExpression
implements ExpressionHandler {
    private final OperatorsFactory operatorsFactory;
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;

    @Inject
    public HandlerPostfixExpression(UtilLayout utilLayout, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, ExpressionsFactory expressionsFactory, OperatorsFactory operatorsFactory) {
        this.operatorsFactory = operatorsFactory;
        this.expressionsFactory = expressionsFactory;
        this.toExpressionConverter = toExpressionConverter;
        this.utilLayout = utilLayout;
    }

    @Override
    public tools.mdsd.jamopp.model.java.expressions.Expression handle(Expression expr) {
        PostfixExpression postfixExpr = (PostfixExpression)expr;
        SuffixUnaryModificationExpression result = this.expressionsFactory.createSuffixUnaryModificationExpression();
        if (postfixExpr.getOperator().equals(PostfixExpression.Operator.DECREMENT)) {
            result.setOperator((UnaryModificationOperator)this.operatorsFactory.createMinusMinus());
        } else {
            result.setOperator((UnaryModificationOperator)this.operatorsFactory.createPlusPlus());
        }
        result.setChild((UnaryModificationExpressionChild)this.toExpressionConverter.convert(postfixExpr.getOperand()));
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)postfixExpr);
        return result;
    }
}

