/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.expressions.PrefixUnaryModificationExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryExpression;
import tools.mdsd.jamopp.model.java.expressions.UnaryModificationExpressionChild;
import tools.mdsd.jamopp.model.java.operators.OperatorsFactory;
import tools.mdsd.jamopp.model.java.operators.UnaryModificationOperator;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerPrefixExpression
implements ExpressionHandler {
    private final OperatorsFactory operatorsFactory;
    private final ExpressionsFactory expressionsFactory;
    private final UtilLayout utilLayout;
    private final Converter<PrefixExpression, UnaryExpression> toUnaryExpressionConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;

    @Inject
    public HandlerPrefixExpression(UtilLayout utilLayout, Converter<PrefixExpression, UnaryExpression> toUnaryExpressionConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, ExpressionsFactory expressionsFactory, OperatorsFactory operatorsFactory) {
        this.operatorsFactory = operatorsFactory;
        this.expressionsFactory = expressionsFactory;
        this.toUnaryExpressionConverter = toUnaryExpressionConverter;
        this.toExpressionConverter = toExpressionConverter;
        this.utilLayout = utilLayout;
    }

    @Override
    public tools.mdsd.jamopp.model.java.expressions.Expression handle(Expression expr) {
        PrefixExpression prefixExpr = (PrefixExpression)expr;
        tools.mdsd.jamopp.model.java.expressions.Expression expression = null;
        if (prefixExpr.getOperator().equals(PrefixExpression.Operator.COMPLEMENT) || prefixExpr.getOperator().equals(PrefixExpression.Operator.NOT) || prefixExpr.getOperator().equals(PrefixExpression.Operator.PLUS) || prefixExpr.getOperator().equals(PrefixExpression.Operator.MINUS)) {
            expression = (tools.mdsd.jamopp.model.java.expressions.Expression)this.toUnaryExpressionConverter.convert(prefixExpr);
        } else if (prefixExpr.getOperator().equals(PrefixExpression.Operator.DECREMENT) || prefixExpr.getOperator().equals(PrefixExpression.Operator.INCREMENT)) {
            PrefixUnaryModificationExpression result = this.expressionsFactory.createPrefixUnaryModificationExpression();
            if (prefixExpr.getOperator().equals(PrefixExpression.Operator.DECREMENT)) {
                result.setOperator((UnaryModificationOperator)this.operatorsFactory.createMinusMinus());
            } else {
                result.setOperator((UnaryModificationOperator)this.operatorsFactory.createPlusPlus());
            }
            result.setChild((UnaryModificationExpressionChild)this.toExpressionConverter.convert(prefixExpr.getOperand()));
            this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)prefixExpr);
            expression = result;
        }
        return expression;
    }
}

