/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.expression;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SwitchExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.Switch;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.ExpressionHandler;
import tools.mdsd.jamopp.parser.interfaces.converter.ToSwitchCasesAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class HandlerSwitchExpression
implements ExpressionHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout utilLayout;
    private final ToSwitchCasesAndSetConverter utilStatementConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter;

    @Inject
    public HandlerSwitchExpression(ToSwitchCasesAndSetConverter utilStatementConverter, UtilLayout utilLayout, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> toExpressionConverter, StatementsFactory statementsFactory) {
        this.statementsFactory = statementsFactory;
        this.toExpressionConverter = toExpressionConverter;
        this.utilLayout = utilLayout;
        this.utilStatementConverter = utilStatementConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.expressions.Expression handle(Expression expr) {
        SwitchExpression switchExpr = (SwitchExpression)expr;
        Switch result = this.statementsFactory.createSwitch();
        result.setVariable(this.toExpressionConverter.convert(switchExpr.getExpression()));
        this.utilStatementConverter.convert(result, switchExpr.statements());
        this.utilLayout.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)switchExpr);
        return result;
    }
}

