/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.Statement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.Break;
import tools.mdsd.jamopp.model.java.statements.JumpLabel;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class BreakStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Set<JumpLabel> currentJumpLabels;

    @Inject
    public BreakStatementHandler(StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Set<JumpLabel> currentJumpLabels) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.currentJumpLabels = currentJumpLabels;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        BreakStatement breakSt = (BreakStatement)statement;
        Break result = this.statementsFactory.createBreak();
        if (breakSt.getLabel() != null) {
            JumpLabel proxyTarget = this.currentJumpLabels.stream().filter(label -> label.getName().equals(breakSt.getLabel().getIdentifier())).findFirst().get();
            result.setTarget(proxyTarget);
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)breakSt);
        return result;
    }
}

