/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.parameters.OrdinaryParameter;
import tools.mdsd.jamopp.model.java.statements.ForEachLoop;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class EnhancedForStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<SingleVariableDeclaration, OrdinaryParameter> toOrdinaryParameterConverter;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;

    @Inject
    public EnhancedForStatementHandler(Converter<SingleVariableDeclaration, OrdinaryParameter> toOrdinaryParameterConverter, StatementsFactory statementsFactory, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toOrdinaryParameterConverter = toOrdinaryParameterConverter;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        EnhancedForStatement forSt = (EnhancedForStatement)statement;
        ForEachLoop result = this.statementsFactory.createForEachLoop();
        result.setNext(this.toOrdinaryParameterConverter.convert(forSt.getParameter()));
        result.setCollection(this.expressionConverterUtility.convert(forSt.getExpression()));
        result.setStatement(this.statementToStatementConverter.convert(forSt.getBody()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)forSt);
        return result;
    }
}

