/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ExpressionStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<VariableDeclarationExpression, LocalVariable> toLocalVariableConverter;

    @Inject
    public ExpressionStatementHandler(Converter<VariableDeclarationExpression, LocalVariable> toLocalVariableConverter, StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toLocalVariableConverter = toLocalVariableConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        tools.mdsd.jamopp.model.java.statements.ExpressionStatement statementResult;
        ExpressionStatement exprSt = (ExpressionStatement)statement;
        if (exprSt.getExpression().getNodeType() == 58) {
            LocalVariableStatement result = this.statementsFactory.createLocalVariableStatement();
            result.setVariable(this.toLocalVariableConverter.convert((VariableDeclarationExpression)exprSt.getExpression()));
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)exprSt);
            statementResult = result;
        } else {
            tools.mdsd.jamopp.model.java.statements.ExpressionStatement result = this.statementsFactory.createExpressionStatement();
            result.setExpression(this.expressionConverterUtility.convert(exprSt.getExpression()));
            this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)exprSt);
            statementResult = result;
        }
        return statementResult;
    }
}

