/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.expressions.ExpressionList;
import tools.mdsd.jamopp.model.java.expressions.ExpressionsFactory;
import tools.mdsd.jamopp.model.java.statements.ForLoop;
import tools.mdsd.jamopp.model.java.statements.ForLoopInitializer;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class ForStatementHandler
implements StatementHandler {
    private final ExpressionsFactory expressionsFactory;
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<VariableDeclarationExpression, LocalVariable> toLocalVariableConverter;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;

    @Inject
    public ForStatementHandler(Converter<VariableDeclarationExpression, LocalVariable> toLocalVariableConverter, StatementsFactory statementsFactory, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter, UtilLayout layoutInformationConverter, ExpressionsFactory expressionsFactory, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility) {
        this.expressionsFactory = expressionsFactory;
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toLocalVariableConverter = toLocalVariableConverter;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        ForStatement forSt = (ForStatement)statement;
        ForLoop result = this.statementsFactory.createForLoop();
        if (forSt.initializers().size() == 1 && forSt.initializers().get(0) instanceof VariableDeclarationExpression) {
            result.setInit((ForLoopInitializer)this.toLocalVariableConverter.convert((VariableDeclarationExpression)forSt.initializers().get(0)));
        } else {
            ExpressionList ini = this.expressionsFactory.createExpressionList();
            forSt.initializers().forEach(obj -> {
                boolean bl = ini.getExpressions().add((Object)this.expressionConverterUtility.convert((Expression)obj));
            });
            result.setInit((ForLoopInitializer)ini);
        }
        if (forSt.getExpression() != null) {
            result.setCondition(this.expressionConverterUtility.convert(forSt.getExpression()));
        }
        forSt.updaters().forEach(obj -> {
            boolean bl = result.getUpdates().add((Object)this.expressionConverterUtility.convert((Expression)obj));
        });
        result.setStatement(this.statementToStatementConverter.convert(forSt.getBody()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)forSt);
        return result;
    }
}

