/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.Condition;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class IfStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;

    @Inject
    public IfStatementHandler(StatementsFactory statementsFactory, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        IfStatement ifSt = (IfStatement)statement;
        Condition result = this.statementsFactory.createCondition();
        result.setCondition(this.expressionConverterUtility.convert(ifSt.getExpression()));
        result.setStatement(this.statementToStatementConverter.convert(ifSt.getThenStatement()));
        if (ifSt.getElseStatement() != null) {
            result.setElseStatement(this.statementToStatementConverter.convert(ifSt.getElseStatement()));
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)ifSt);
        return result;
    }
}

