/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Statement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.statements.JumpLabel;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;

public class LabeledStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilNamedElement utilNamedElement;
    private final Set<JumpLabel> currentJumpLabels;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;

    @Inject
    public LabeledStatementHandler(UtilNamedElement utilNamedElement, StatementsFactory statementsFactory, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter, UtilLayout layoutInformationConverter, Set<JumpLabel> currentJumpLabels) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilNamedElement = utilNamedElement;
        this.currentJumpLabels = currentJumpLabels;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        LabeledStatement labelSt = (LabeledStatement)statement;
        JumpLabel result = this.statementsFactory.createJumpLabel();
        this.utilNamedElement.setNameOfElement((Name)labelSt.getLabel(), (NamedElement)result);
        this.currentJumpLabels.add(result);
        result.setStatement(this.statementToStatementConverter.convert(labelSt.getBody()));
        this.currentJumpLabels.remove(result);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)labelSt);
        return result;
    }
}

