/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.SynchronizedBlock;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class SynchonizedStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter;

    @Inject
    public SynchonizedStatementHandler(StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility, Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.blockToBlockConverter = blockToBlockConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        SynchronizedStatement synSt = (SynchronizedStatement)statement;
        SynchronizedBlock result = this.statementsFactory.createSynchronizedBlock();
        result.setLockProvider(this.expressionConverterUtility.convert(synSt.getExpression()));
        result.setBlock(this.blockToBlockConverter.convert(synSt.getBody()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)synSt);
        return result;
    }
}

