/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.references.ElementReference;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.statements.CatchBlock;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.TryBlock;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.model.java.variables.Resource;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilReferenceWalker;

public class TryStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final UtilReferenceWalker utilReferenceWalker;
    private final Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter;
    private final Converter<VariableDeclarationExpression, LocalVariable> toLocalVariableConverter;
    private final Converter<CatchClause, CatchBlock> toCatchblockConverter;
    private final Converter<Expression, Reference> toReferenceConverterFromExpression;

    @Inject
    public TryStatementHandler(UtilReferenceWalker utilReferenceWalker, Converter<Expression, Reference> toReferenceConverterFromExpression, Converter<VariableDeclarationExpression, LocalVariable> toLocalVariableConverter, Converter<CatchClause, CatchBlock> toCatchblockConverter, StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.utilReferenceWalker = utilReferenceWalker;
        this.blockToBlockConverter = blockToBlockConverter;
        this.toLocalVariableConverter = toLocalVariableConverter;
        this.toCatchblockConverter = toCatchblockConverter;
        this.toReferenceConverterFromExpression = toReferenceConverterFromExpression;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        TryStatement trySt = (TryStatement)statement;
        TryBlock result = this.statementsFactory.createTryBlock();
        trySt.resources().forEach(obj -> {
            Expression resExpr = (Expression)obj;
            if (resExpr instanceof VariableDeclarationExpression) {
                result.getResources().add((Object)((Resource)this.toLocalVariableConverter.convert((VariableDeclarationExpression)resExpr)));
            } else {
                result.getResources().add((Object)((ElementReference)this.utilReferenceWalker.walkUp(this.toReferenceConverterFromExpression.convert(resExpr))));
            }
        });
        result.setBlock(this.blockToBlockConverter.convert(trySt.getBody()));
        trySt.catchClauses().forEach(obj -> {
            boolean bl = result.getCatchBlocks().add((Object)this.toCatchblockConverter.convert((CatchClause)obj));
        });
        if (trySt.getFinally() != null) {
            result.setFinallyBlock(this.blockToBlockConverter.convert(trySt.getFinally()));
        }
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)trySt);
        return result;
    }
}

