/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import tools.mdsd.jamopp.model.java.arrays.ArrayTypeable;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.modifiers.AnnotationInstanceOrModifier;
import tools.mdsd.jamopp.model.java.statements.LocalVariableStatement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionAfterAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.converter.ToArrayDimensionsAndSetConverter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

public class VariableDeclarationStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final JdtResolver jdtResolverUtility;
    private final UtilNamedElement utilNamedElement;
    private final ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter;
    private final ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility;
    private final Converter<Type, TypeReference> toTypeReferenceConverter;
    private final Converter<IExtendedModifier, AnnotationInstanceOrModifier> annotationInstanceConverter;
    private final Converter<VariableDeclarationFragment, AdditionalLocalVariable> toAdditionalLocalVariableConverter;

    @Inject
    public VariableDeclarationStatementHandler(ToArrayDimensionsAndSetConverter utilToArrayDimensionsAndSetConverter, ToArrayDimensionAfterAndSetConverter utilToArrayDimensionAfterAndSetConverter, UtilNamedElement utilNamedElement, Converter<Type, TypeReference> toTypeReferenceConverter, Converter<VariableDeclarationFragment, AdditionalLocalVariable> toAdditionalLocalVariableConverter, StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, JdtResolver jdtResolverUtility, Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility, Converter<IExtendedModifier, AnnotationInstanceOrModifier> annotationInstanceConverter) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.jdtResolverUtility = jdtResolverUtility;
        this.utilNamedElement = utilNamedElement;
        this.utilToArrayDimensionsAndSetConverter = utilToArrayDimensionsAndSetConverter;
        this.utilToArrayDimensionAfterAndSetConverter = utilToArrayDimensionAfterAndSetConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toTypeReferenceConverter = toTypeReferenceConverter;
        this.annotationInstanceConverter = annotationInstanceConverter;
        this.toAdditionalLocalVariableConverter = toAdditionalLocalVariableConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        VariableDeclarationStatement varSt = (VariableDeclarationStatement)statement;
        LocalVariableStatement result = this.statementsFactory.createLocalVariableStatement();
        VariableDeclarationFragment frag = (VariableDeclarationFragment)varSt.fragments().get(0);
        IVariableBinding binding = frag.resolveBinding();
        LocalVariable locVar = binding == null ? this.jdtResolverUtility.getLocalVariable(String.valueOf(frag.getName().getIdentifier()) + "-" + frag.hashCode()) : this.jdtResolverUtility.getLocalVariable(binding);
        this.utilNamedElement.setNameOfElement((Name)frag.getName(), (NamedElement)locVar);
        varSt.modifiers().forEach(obj -> {
            boolean bl = locVar.getAnnotationsAndModifiers().add((Object)this.annotationInstanceConverter.convert((IExtendedModifier)obj));
        });
        locVar.setTypeReference(this.toTypeReferenceConverter.convert(varSt.getType()));
        this.utilToArrayDimensionsAndSetConverter.convert(varSt.getType(), (ArrayTypeable)locVar);
        frag.extraDimensions().forEach(obj -> this.utilToArrayDimensionAfterAndSetConverter.convert((Dimension)obj, (ArrayTypeable)locVar));
        if (frag.getInitializer() != null) {
            locVar.setInitialValue(this.expressionConverterUtility.convert(frag.getInitializer()));
        }
        int index = 1;
        while (index < varSt.fragments().size()) {
            locVar.getAdditionalLocalVariables().add((Object)this.toAdditionalLocalVariableConverter.convert((VariableDeclarationFragment)varSt.fragments().get(index)));
            ++index;
        }
        result.setVariable(locVar);
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)varSt);
        return result;
    }
}

