/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.converter.statement;

import com.google.inject.Inject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.WhileStatement;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.statements.WhileLoop;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.converter.StatementHandler;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class WhileStatementHandler
implements StatementHandler {
    private final StatementsFactory statementsFactory;
    private final UtilLayout layoutInformationConverter;
    private final Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;

    @Inject
    public WhileStatementHandler(StatementsFactory statementsFactory, UtilLayout layoutInformationConverter, Converter<Expression, tools.mdsd.jamopp.model.java.expressions.Expression> expressionConverterUtility, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter) {
        this.statementsFactory = statementsFactory;
        this.layoutInformationConverter = layoutInformationConverter;
        this.expressionConverterUtility = expressionConverterUtility;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    @Override
    public tools.mdsd.jamopp.model.java.statements.Statement handle(Statement statement) {
        WhileStatement whileSt = (WhileStatement)statement;
        WhileLoop result = this.statementsFactory.createWhileLoop();
        result.setCondition(this.expressionConverterUtility.convert(whileSt.getExpression()));
        result.setStatement(this.statementToStatementConverter.convert(whileSt.getBody()));
        this.layoutInformationConverter.convertToMinimalLayoutInformation((Commentable)result, (ASTNode)whileSt);
        return result;
    }
}

