/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.helper;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.dom.ASTNode;
import tools.mdsd.jamopp.commons.layout.LayoutFactory;
import tools.mdsd.jamopp.commons.layout.LayoutInformation;
import tools.mdsd.jamopp.commons.layout.MinimalLayoutInformation;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.containers.JavaRoot;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilLayout;

public class UtilLayoutImpl
implements UtilLayout {
    private final LayoutFactory layoutFactory;
    private MinimalLayoutInformation currentRootLayout;
    private boolean layoutSet;

    @Inject
    public UtilLayoutImpl(LayoutFactory layoutFactory) {
        this.layoutFactory = layoutFactory;
        this.layoutSet = false;
    }

    @Override
    public void convertJavaRootLayoutInformation(JavaRoot root, ASTNode rootSource, String sourceCode) {
        this.layoutSet = false;
        if (sourceCode != null) {
            this.currentRootLayout = this.layoutFactory.createMinimalLayoutInformation();
            this.currentRootLayout.setVisibleTokenText(sourceCode);
            this.currentRootLayout.setStartOffset(rootSource.getStartPosition());
            this.currentRootLayout.setLength(rootSource.getLength());
            this.currentRootLayout.setObject((EObject)root);
            this.currentRootLayout.setRootLayout((LayoutInformation)this.currentRootLayout);
            root.getLayoutInformations().add((Object)this.currentRootLayout);
            this.layoutSet = true;
        }
    }

    @Override
    public void convertToMinimalLayoutInformation(Commentable target, ASTNode source) {
        if (this.layoutSet) {
            MinimalLayoutInformation information = this.layoutFactory.createMinimalLayoutInformation();
            information.setStartOffset(source.getStartPosition());
            information.setLength(source.getLength());
            information.setObject((EObject)target);
            information.setRootLayout((LayoutInformation)this.currentRootLayout);
            target.getLayoutInformations().add((Object)information);
        }
    }
}

