/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.helper;

import java.util.Collections;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import tools.mdsd.jamopp.model.java.commons.NamedElement;
import tools.mdsd.jamopp.model.java.commons.NamespaceAwareElement;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilNamedElement;

public class UtilNamedElementImpl
implements UtilNamedElement {
    @Override
    public void addNameToNameSpaceAndElement(Name name, NamespaceAwareElement namespaceElement, NamedElement namedElement) {
        if (name.isSimpleName()) {
            namedElement.setName(((SimpleName)name).getIdentifier());
        } else if (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            namedElement.setName(qualifiedName.getName().getIdentifier());
            this.addNameToNameSpace(qualifiedName.getQualifier(), namespaceElement);
        }
    }

    @Override
    public void addNameToNameSpace(Name name, NamespaceAwareElement namespaceElement) {
        if (name.isSimpleName()) {
            SimpleName simpleName = (SimpleName)name;
            namespaceElement.getNamespaces().add(0, (Object)simpleName.getIdentifier());
        } else if (name.isQualifiedName()) {
            QualifiedName qualifiedName = (QualifiedName)name;
            namespaceElement.getNamespaces().add(0, (Object)qualifiedName.getName().getIdentifier());
            this.addNameToNameSpace(qualifiedName.getQualifier(), namespaceElement);
        }
    }

    @Override
    public void setNameOfElement(Name name, NamedElement namedElement) {
        if (name.isSimpleName()) {
            SimpleName simpleName = (SimpleName)name;
            namedElement.setName(simpleName.getIdentifier());
        } else {
            QualifiedName qualifiedName = (QualifiedName)name;
            namedElement.setName(qualifiedName.getName().getIdentifier());
        }
    }

    @Override
    public void convertToNameAndSet(ITypeBinding binding, NamedElement element) {
        String name = binding.getName();
        if (binding.isParameterizedType()) {
            name = name.substring(0, name.indexOf(60));
        } else if (binding.isArray()) {
            name = name.substring(0, name.indexOf(91));
        }
        element.setName(name);
    }

    @Override
    public void convertToNamespacesAndSet(String namespaces, NamespaceAwareElement ele) {
        ele.getNamespaces().clear();
        String[] singleNamespaces = namespaces.split("\\.");
        Collections.addAll(ele.getNamespaces(), singleNamespaces);
    }
}

