/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.helper;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Statement;
import tools.mdsd.jamopp.model.java.annotations.AnnotationAttributeSetting;
import tools.mdsd.jamopp.model.java.annotations.AnnotationValue;
import tools.mdsd.jamopp.model.java.annotations.SingleAnnotationParameter;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.parser.interfaces.converter.Converter;
import tools.mdsd.jamopp.parser.interfaces.helper.UtilTypeInstructionSeparation;
import tools.mdsd.jamopp.parser.interfaces.resolver.JdtResolver;

@Singleton
public class UtilTypeInstructionSeparationImpl
implements UtilTypeInstructionSeparation {
    private final JdtResolver jdtResolverUtility;
    private final Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility;
    private final Converter<org.eclipse.jdt.core.dom.Expression, AnnotationValue> toAnnotationValueConverter;
    private final Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter;
    private final Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter;
    private final Map<Block, Method> methods = new ConcurrentHashMap<Block, Method>();
    private final Map<Block, Constructor> constructors = new ConcurrentHashMap<Block, Constructor>();
    private final Map<org.eclipse.jdt.core.dom.Expression, Field> fields = new ConcurrentHashMap<org.eclipse.jdt.core.dom.Expression, Field>();
    private final Map<org.eclipse.jdt.core.dom.Expression, AdditionalField> addFields = new ConcurrentHashMap<org.eclipse.jdt.core.dom.Expression, AdditionalField>();
    private final Map<Block, tools.mdsd.jamopp.model.java.statements.Block> initializers = new ConcurrentHashMap<Block, tools.mdsd.jamopp.model.java.statements.Block>();
    private final Map<org.eclipse.jdt.core.dom.Expression, InterfaceMethod> annotationMethods = new ConcurrentHashMap<org.eclipse.jdt.core.dom.Expression, InterfaceMethod>();
    private final Map<org.eclipse.jdt.core.dom.Expression, SingleAnnotationParameter> singleAnnotations = new ConcurrentHashMap<org.eclipse.jdt.core.dom.Expression, SingleAnnotationParameter>();
    private final Map<org.eclipse.jdt.core.dom.Expression, AnnotationAttributeSetting> annotationSetting = new ConcurrentHashMap<org.eclipse.jdt.core.dom.Expression, AnnotationAttributeSetting>();
    private final Set<EObject> visitedObjects = new HashSet<EObject>();

    @Inject
    public UtilTypeInstructionSeparationImpl(Converter<org.eclipse.jdt.core.dom.Expression, AnnotationValue> toAnnotationValueConverter, Converter<Statement, tools.mdsd.jamopp.model.java.statements.Statement> statementToStatementConverter, JdtResolver jdtResolverUtility, Converter<org.eclipse.jdt.core.dom.Expression, Expression> expressionConverterUtility, Converter<Block, tools.mdsd.jamopp.model.java.statements.Block> blockToBlockConverter) {
        this.jdtResolverUtility = jdtResolverUtility;
        this.expressionConverterUtility = expressionConverterUtility;
        this.toAnnotationValueConverter = toAnnotationValueConverter;
        this.blockToBlockConverter = blockToBlockConverter;
        this.statementToStatementConverter = statementToStatementConverter;
    }

    @Override
    public void convertAll() {
        int oldSize;
        int newSize = this.methods.size() + this.constructors.size() + this.fields.size() + this.addFields.size() + this.initializers.size() + this.annotationMethods.size() + this.singleAnnotations.size() + this.annotationSetting.size();
        do {
            oldSize = newSize;
            this.handleMethods();
            this.handleConstructors();
            this.handleFields();
            this.handleAddFields();
            this.handleInitializers();
            this.handleAnnotationMethods();
            this.handleSingleAnnotations();
            this.handleAnnotationSetting();
        } while ((newSize = this.methods.size() + this.constructors.size() + this.fields.size() + this.addFields.size() + this.initializers.size() + this.annotationMethods.size() + this.singleAnnotations.size() + this.annotationSetting.size()) != oldSize);
        this.methods.clear();
        this.constructors.clear();
        this.fields.clear();
        this.addFields.clear();
        this.initializers.clear();
        this.annotationMethods.clear();
        this.singleAnnotations.clear();
        this.annotationSetting.clear();
        this.visitedObjects.clear();
    }

    private void handleAnnotationSetting() {
        HashMap<org.eclipse.jdt.core.dom.Expression, AnnotationAttributeSetting> clone = new HashMap<org.eclipse.jdt.core.dom.Expression, AnnotationAttributeSetting>(this.annotationSetting);
        Iterator<org.eclipse.jdt.core.dom.Expression> exprIter = clone.keySet().iterator();
        while (exprIter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(exprIter.next()))) continue;
            exprIter.remove();
        }
        clone.forEach((expr, aas) -> {
            this.visitedObjects.add((EObject)aas);
            aas.setValue(this.toAnnotationValueConverter.convert((org.eclipse.jdt.core.dom.Expression)expr));
        });
    }

    private void handleSingleAnnotations() {
        HashMap<org.eclipse.jdt.core.dom.Expression, SingleAnnotationParameter> clone = new HashMap<org.eclipse.jdt.core.dom.Expression, SingleAnnotationParameter>(this.singleAnnotations);
        Iterator<org.eclipse.jdt.core.dom.Expression> exprIter = clone.keySet().iterator();
        while (exprIter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(exprIter.next()))) continue;
            exprIter.remove();
        }
        clone.forEach((expr, sap) -> {
            this.visitedObjects.add((EObject)sap);
            sap.setValue(this.toAnnotationValueConverter.convert((org.eclipse.jdt.core.dom.Expression)expr));
        });
    }

    private void handleAnnotationMethods() {
        HashMap<org.eclipse.jdt.core.dom.Expression, InterfaceMethod> clone = new HashMap<org.eclipse.jdt.core.dom.Expression, InterfaceMethod>(this.annotationMethods);
        Iterator<org.eclipse.jdt.core.dom.Expression> exprIter = clone.keySet().iterator();
        while (exprIter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(exprIter.next()))) continue;
            exprIter.remove();
        }
        clone.forEach((expr, m) -> {
            this.visitedObjects.add((EObject)m);
            m.setDefaultValue(this.toAnnotationValueConverter.convert((org.eclipse.jdt.core.dom.Expression)expr));
        });
    }

    private void handleInitializers() {
        HashMap<Block, tools.mdsd.jamopp.model.java.statements.Block> clone = new HashMap<Block, tools.mdsd.jamopp.model.java.statements.Block>(this.initializers);
        Iterator<Block> iter = clone.keySet().iterator();
        while (iter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(iter.next()))) continue;
            iter.remove();
        }
        clone.forEach((b1, b2) -> {
            this.visitedObjects.add((EObject)b2);
            this.jdtResolverUtility.prepareNextUid();
            b1.statements().forEach(obj -> {
                boolean bl = b2.getStatements().add((Object)this.statementToStatementConverter.convert((Statement)obj));
            });
        });
    }

    private void handleAddFields() {
        HashMap<org.eclipse.jdt.core.dom.Expression, AdditionalField> clone = new HashMap<org.eclipse.jdt.core.dom.Expression, AdditionalField>(this.addFields);
        Iterator<org.eclipse.jdt.core.dom.Expression> exprIter = clone.keySet().iterator();
        while (exprIter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(exprIter.next()))) continue;
            exprIter.remove();
        }
        clone.forEach((expr, f) -> {
            this.visitedObjects.add((EObject)f);
            f.setInitialValue(this.expressionConverterUtility.convert((org.eclipse.jdt.core.dom.Expression)expr));
        });
    }

    private void handleFields() {
        HashMap<org.eclipse.jdt.core.dom.Expression, Field> clone = new HashMap<org.eclipse.jdt.core.dom.Expression, Field>(this.fields);
        Iterator<org.eclipse.jdt.core.dom.Expression> exprIter = clone.keySet().iterator();
        while (exprIter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(exprIter.next()))) continue;
            exprIter.remove();
        }
        clone.forEach((expr, f) -> {
            this.visitedObjects.add((EObject)f);
            f.setInitialValue(this.expressionConverterUtility.convert((org.eclipse.jdt.core.dom.Expression)expr));
        });
    }

    private void handleConstructors() {
        HashMap<Block, Constructor> clone = new HashMap<Block, Constructor>(this.constructors);
        Iterator<Block> iter = clone.keySet().iterator();
        while (iter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(iter.next()))) continue;
            iter.remove();
        }
        clone.forEach((b, c) -> {
            this.visitedObjects.add((EObject)c);
            c.setBlock(this.blockToBlockConverter.convert((Block)b));
        });
    }

    private void handleMethods() {
        HashMap<Block, Method> clone = new HashMap<Block, Method>(this.methods);
        Iterator<Block> iter = clone.keySet().iterator();
        while (iter.hasNext()) {
            if (!this.visitedObjects.contains(clone.get(iter.next()))) continue;
            iter.remove();
        }
        clone.forEach((b, m) -> {
            this.visitedObjects.add((EObject)m);
            m.setStatement((tools.mdsd.jamopp.model.java.statements.Statement)this.blockToBlockConverter.convert((Block)b));
        });
    }

    @Override
    public void addMethod(Block block, Method method) {
        this.methods.put(block, method);
    }

    @Override
    public void addConstructor(Block block, Constructor constructor) {
        this.constructors.put(block, constructor);
    }

    @Override
    public void addField(org.eclipse.jdt.core.dom.Expression initializer, Field field) {
        this.fields.put(initializer, field);
    }

    @Override
    public void addAdditionalField(org.eclipse.jdt.core.dom.Expression initializer, AdditionalField field) {
        this.addFields.put(initializer, field);
    }

    @Override
    public void addInitializer(Block block, tools.mdsd.jamopp.model.java.statements.Block correspondingBlock) {
        this.initializers.put(block, correspondingBlock);
    }

    @Override
    public void addAnnotationMethod(org.eclipse.jdt.core.dom.Expression value, InterfaceMethod method) {
        this.annotationMethods.put(value, method);
    }

    @Override
    public void addSingleAnnotationParameter(org.eclipse.jdt.core.dom.Expression value, SingleAnnotationParameter param) {
        this.singleAnnotations.put(value, param);
    }

    @Override
    public void addAnnotationAttributeSetting(org.eclipse.jdt.core.dom.Expression value, AnnotationAttributeSetting setting) {
        this.annotationSetting.put(value, setting);
    }
}

