/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.jamopp;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppClasspathEntriesSearcher;

public class JamoppClasspathEntriesSearcherImpl
implements JamoppClasspathEntriesSearcher {
    private final Logger logger;

    @Inject
    public JamoppClasspathEntriesSearcherImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String[] getClasspathEntries(Path dir) {
        String[] entries;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
                entries = (String[])paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(this::isJar).map(Path::toAbsolutePath).map(Path::normalize).map(Path::toString).toArray(String[]::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error((Object)dir, (Throwable)e);
            entries = new String[]{};
        }
        return entries;
    }

    private boolean isJar(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().toLowerCase(Locale.US).endsWith("jar");
    }
}

