/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.jamopp;

import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppCompilationUnitsFactory;

public class JamoppCompilationUnitsFactoryImpl
implements JamoppCompilationUnitsFactory {
    private final Logger logger;

    @Inject
    public JamoppCompilationUnitsFactoryImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Map<String, CompilationUnit> getCompilationUnits(ASTParser parser, String[] classpathEntries, String[] sources, String[] encodings) {
        final ConcurrentHashMap<String, CompilationUnit> compilationUnits = new ConcurrentHashMap<String, CompilationUnit>();
        try {
            parser.setEnvironment(classpathEntries, new String[0], new String[0], true);
            parser.createASTs(sources, encodings, new String[0], new FileASTRequestor(){

                public void acceptAST(String sourceFilePath, CompilationUnit ast) {
                    compilationUnits.put(sourceFilePath, ast);
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            this.logger.error((Object)String.valueOf(sources), (Throwable)e);
        }
        return compilationUnits;
    }
}

