/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.jamopp;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import tools.mdsd.jamopp.parser.interfaces.jamopp.JamoppJavaParserFactory;

public class JamoppJavaParserFactoryImpl
implements JamoppJavaParserFactory {
    private final Logger logger;
    private final Map<String, Mapping> mappings;

    @Inject
    public JamoppJavaParserFactoryImpl(Logger logger) {
        this.logger = logger;
        this.mappings = new HashMap<String, Mapping>();
        this.mappings.put("1.1", new Mapping("1.1", 2));
        this.mappings.put("1.2", new Mapping("1.2", 2));
        this.mappings.put("1.3", new Mapping("1.3", 3));
        this.mappings.put("1.4", new Mapping("1.4", 4));
        this.mappings.put("1.5", new Mapping("1.5", 8));
        this.mappings.put("1.6", new Mapping("1.6", 8));
        this.mappings.put("1.7", new Mapping("1.7", 8));
        this.mappings.put("1.8", new Mapping("1.8", 8));
        this.mappings.put("9", new Mapping("9", 9));
        this.mappings.put("10", new Mapping("10", 10));
        this.mappings.put("11", new Mapping("11", 11));
        this.mappings.put("12", new Mapping("12", 12));
        this.mappings.put("13", new Mapping("13", 13));
        this.mappings.put("14", new Mapping("14", 14));
        this.mappings.put("15", new Mapping("15", 15));
        this.mappings.put("16", new Mapping("16", 16));
        this.mappings.put("17", new Mapping("17", 17));
    }

    @Override
    public ASTParser getJavaParser(String version) {
        int astParserLevel;
        String javaCoreVersion;
        String stripedVersion = String.valueOf(version).strip();
        Mapping mapping = this.mappings.get(stripedVersion);
        if (mapping != null) {
            javaCoreVersion = mapping.getJavaCoreVersion();
            astParserLevel = mapping.getAstParserLevel();
        } else {
            javaCoreVersion = JavaCore.latestSupportedJavaVersion();
            astParserLevel = AST.getJLSLatest();
            this.logger.warn((Object)String.format("No version was found for %s, so the last supported version is used.", stripedVersion));
        }
        ASTParser parser = ASTParser.newParser((int)astParserLevel);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        parser.setCompilerOptions(Map.of("org.eclipse.jdt.core.compiler.source", javaCoreVersion, "org.eclipse.jdt.core.compiler.compliance", javaCoreVersion, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", javaCoreVersion));
        return parser;
    }

    private static class Mapping {
        private final String javaCoreVersion;
        private final int astParserLevel;

        private Mapping(String javaCoreVersion, int astParserLevel) {
            this.javaCoreVersion = javaCoreVersion;
            this.astParserLevel = astParserLevel;
        }

        private int getAstParserLevel() {
            return this.astParserLevel;
        }

        private String getJavaCoreVersion() {
            return this.javaCoreVersion;
        }
    }
}

