/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.jdt.core.dom.IBinding;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;

public abstract class AbstractResolverWithCache<C, B extends IBinding>
implements ResolverWithCache<C, B> {
    private final Map<String, C> bindings;

    @Inject
    public AbstractResolverWithCache(Map<String, C> bindings) {
        this.bindings = bindings;
    }

    @Override
    public void clearBindings() {
        this.bindings.clear();
    }

    @Override
    public void forEachBinding(BiConsumer<? super String, ? super C> biConsumer) {
        this.bindings.forEach(biConsumer);
    }

    @Override
    public void forEachBindingOnCopy(BiConsumer<? super String, ? super C> biConsumer) {
        new HashMap<String, C>(this.bindings).forEach(biConsumer);
    }

    @Override
    public int bindingsSize() {
        return this.bindings.size();
    }

    @Override
    public Collection<C> getBindings() {
        return this.bindings.values();
    }

    @Override
    public boolean containsKey(String varName) {
        return this.bindings.containsKey(varName);
    }

    @Override
    public C get(String varName) {
        return this.bindings.get(varName);
    }

    @Override
    public void putBinding(String name, C value) {
        this.bindings.put(name, value);
    }
}

