/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.AdditionalField;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class AdditionalFieldResolver
extends AbstractResolverWithCache<AdditionalField, IVariableBinding> {
    private final Set<IVariableBinding> variableBindings;
    private final MembersFactory membersFactory;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<IVariableBinding> toFieldNameConverter;

    @Inject
    public AdditionalFieldResolver(Map<String, AdditionalField> bindings, Set<IVariableBinding> variableBindings, MembersFactory membersFactory, Resolver<Classifier, ITypeBinding> classifierResolver, ToStringConverter<IVariableBinding> toFieldNameConverter) {
        super(bindings);
        this.variableBindings = variableBindings;
        this.membersFactory = membersFactory;
        this.classifierResolver = classifierResolver;
        this.toFieldNameConverter = toFieldNameConverter;
    }

    @Override
    public AdditionalField getByBinding(IVariableBinding binding) {
        AdditionalField additionalField;
        String varName = this.toFieldNameConverter.convert(binding);
        if (this.containsKey(varName)) {
            additionalField = (AdditionalField)this.get(varName);
        } else {
            this.variableBindings.add(binding);
            AdditionalField result = null;
            ConcreteClassifier potClass = (ConcreteClassifier)this.classifierResolver.getByBinding(binding.getDeclaringClass());
            if (potClass != null) {
                result = this.handleNullPotClass(binding, potClass);
            }
            if (result == null) {
                result = this.membersFactory.createAdditionalField();
            }
            this.putBinding(varName, result);
            additionalField = result;
        }
        return additionalField;
    }

    private AdditionalField handleNullPotClass(IVariableBinding binding, ConcreteClassifier potClass) {
        AdditionalField additionalField = null;
        for (Member mem : potClass.getMembers()) {
            if (!(mem instanceof Field var6_6)) continue;
            boolean leave = false;
            for (AdditionalField af : field.getAdditionalFields()) {
                if (!af.getName().equals(binding.getName())) continue;
                additionalField = af;
                leave = true;
                break;
            }
            if (leave) break;
        }
        return additionalField;
    }

    @Override
    public AdditionalField getByName(String name) {
        AdditionalField additionalField;
        if (this.containsKey(name)) {
            additionalField = (AdditionalField)this.get(name);
        } else {
            AdditionalField result = this.membersFactory.createAdditionalField();
            this.putBinding(name, result);
            additionalField = result;
        }
        return additionalField;
    }
}

