/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.variables.AdditionalLocalVariable;
import tools.mdsd.jamopp.model.java.variables.VariablesFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;

public class AdditionalLocalVariableResolver
extends AbstractResolverWithCache<AdditionalLocalVariable, IVariableBinding> {
    private final Set<IVariableBinding> variableBindings;
    private final VariablesFactory variablesFactory;
    private final ConverterWithBoolean<IVariableBinding> toParameterNameConverter;

    @Inject
    public AdditionalLocalVariableResolver(Map<String, AdditionalLocalVariable> bindings, VariablesFactory variablesFactory, Set<IVariableBinding> variableBindings, ConverterWithBoolean<IVariableBinding> toParameterNameConverter) {
        super(bindings);
        this.variableBindings = variableBindings;
        this.variablesFactory = variablesFactory;
        this.toParameterNameConverter = toParameterNameConverter;
    }

    @Override
    public AdditionalLocalVariable getByBinding(IVariableBinding binding) {
        this.variableBindings.add(binding);
        return this.getByName(this.toParameterNameConverter.convertToParameterName(binding, true));
    }

    @Override
    public AdditionalLocalVariable getByName(String name) {
        AdditionalLocalVariable additionalLocalVariable;
        if (this.containsKey(name)) {
            additionalLocalVariable = (AdditionalLocalVariable)this.get(name);
        } else {
            AdditionalLocalVariable result = this.variablesFactory.createAdditionalLocalVariable();
            this.putBinding(name, result);
            additionalLocalVariable = result;
        }
        return additionalLocalVariable;
    }
}

