/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class AnnotationResolver
extends AbstractResolverWithCache<Annotation, ITypeBinding> {
    private final Set<ITypeBinding> typeBindings;
    private final ClassifiersFactory classifiersFactory;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public AnnotationResolver(Map<String, Annotation> bindings, Set<ITypeBinding> typeBindings, ClassifiersFactory classifiersFactory, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter) {
        super(bindings);
        this.typeBindings = typeBindings;
        this.classifiersFactory = classifiersFactory;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public Annotation getByBinding(ITypeBinding binding) {
        this.typeBindings.add(binding);
        return this.getByName(this.toTypeNameConverter.convert(binding));
    }

    @Override
    public Annotation getByName(String name) {
        Annotation annotation;
        if (this.containsKey(name)) {
            annotation = (Annotation)this.get(name);
        } else {
            ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(name);
            Annotation result = potClass instanceof Annotation ? (Annotation)potClass : this.classifiersFactory.createAnnotation();
            this.putBinding(name, result);
            annotation = result;
        }
        return annotation;
    }
}

