/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class AnonymousClassResolver
extends AbstractResolverWithCache<AnonymousClass, ITypeBinding> {
    private final ClassifiersFactory classifiersFactory;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public AnonymousClassResolver(Map<String, AnonymousClass> bindings, ClassifiersFactory classifiersFactory, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter) {
        super(bindings);
        this.classifiersFactory = classifiersFactory;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public AnonymousClass getByBinding(ITypeBinding binding) {
        String typeName = this.toTypeNameConverter.convert(binding);
        return this.getByName(typeName);
    }

    @Override
    public AnonymousClass getByName(String name) {
        AnonymousClass anonymousClass;
        if (this.containsKey(name)) {
            anonymousClass = (AnonymousClass)this.get(name);
        } else {
            AnonymousClass result = this.classifiersFactory.createAnonymousClass();
            this.putBinding(name, result);
            anonymousClass = result;
        }
        return anonymousClass;
    }
}

