/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.parameters.CatchParameter;
import tools.mdsd.jamopp.model.java.parameters.ParametersFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;

public class CatchParameterResolver
extends AbstractResolverWithCache<CatchParameter, IVariableBinding> {
    private final Set<IVariableBinding> variableBindings;
    private final ParametersFactory parametersFactory;
    private final ConverterWithBoolean<IVariableBinding> toParameterNameConverter;

    @Inject
    public CatchParameterResolver(Map<String, CatchParameter> bindings, Set<IVariableBinding> variableBindings, ParametersFactory parametersFactory, ConverterWithBoolean<IVariableBinding> toParameterNameConverter) {
        super(bindings);
        this.variableBindings = variableBindings;
        this.parametersFactory = parametersFactory;
        this.toParameterNameConverter = toParameterNameConverter;
    }

    @Override
    public CatchParameter getByBinding(IVariableBinding binding) {
        this.variableBindings.add(binding);
        return this.getByName(this.toParameterNameConverter.convertToParameterName(binding, true));
    }

    @Override
    public CatchParameter getByName(String name) {
        CatchParameter catchParameter;
        if (this.containsKey(name)) {
            catchParameter = (CatchParameter)this.get(name);
        } else {
            CatchParameter result = this.parametersFactory.createCatchParameter();
            this.putBinding(name, result);
            catchParameter = result;
        }
        return catchParameter;
    }
}

