/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.ClassMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.MethodChecker;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ClassMethodResolver
extends AbstractResolverWithCache<ClassMethod, IMethodBinding> {
    private final Set<IMethodBinding> methodBindings;
    private final StatementsFactory statementsFactory;
    private final TypesFactory typesFactory;
    private final MembersFactory membersFactory;
    private final MethodChecker methodCheckerImpl;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<IMethodBinding> toMethodNameConverter;

    @Inject
    public ClassMethodResolver(Map<String, ClassMethod> bindings, TypesFactory typesFactory, StatementsFactory statementsFactory, Set<IMethodBinding> methodBindings, MembersFactory membersFactory, Resolver<Classifier, ITypeBinding> classifierResolver, MethodChecker methodCheckerImpl, ToStringConverter<IMethodBinding> toMethodNameConverter) {
        super(bindings);
        this.methodBindings = methodBindings;
        this.statementsFactory = statementsFactory;
        this.typesFactory = typesFactory;
        this.membersFactory = membersFactory;
        this.classifierResolver = classifierResolver;
        this.methodCheckerImpl = methodCheckerImpl;
        this.toMethodNameConverter = toMethodNameConverter;
    }

    @Override
    public ClassMethod getByBinding(IMethodBinding binding) {
        ClassMethod classMethod;
        IMethodBinding methodDeclaration = binding.getMethodDeclaration();
        this.methodBindings.add(methodDeclaration);
        String methName = this.toMethodNameConverter.convert(methodDeclaration);
        if (this.containsKey(methName)) {
            classMethod = (ClassMethod)this.get(methName);
        } else {
            ConcreteClassifier classifier = (ConcreteClassifier)this.classifierResolver.getByBinding(methodDeclaration.getDeclaringClass());
            ClassMethod result = null;
            if (classifier != null) {
                result = this.handleClassifier(methodDeclaration, classifier);
            }
            if (result == null) {
                result = this.createNewClassMethod();
            }
            this.putBinding(methName, result);
            classMethod = result;
        }
        return classMethod;
    }

    private ClassMethod handleClassifier(IMethodBinding binding, ConcreteClassifier classifier) {
        ClassMethod result = null;
        for (Member mem : classifier.getMembers()) {
            if (mem instanceof ClassMethod && (result = (ClassMethod)this.methodCheckerImpl.checkMethod((Method)mem, binding)) != null) break;
        }
        return result;
    }

    @Override
    public ClassMethod getByName(String name) {
        ClassMethod classMethod;
        if (this.containsKey(name)) {
            classMethod = (ClassMethod)this.get(name);
        } else {
            ClassMethod result = this.createNewClassMethod();
            this.putBinding(name, result);
            classMethod = result;
        }
        return classMethod;
    }

    private ClassMethod createNewClassMethod() {
        ClassMethod result = this.membersFactory.createClassMethod();
        result.setTypeReference((TypeReference)this.typesFactory.createVoid());
        Block block = this.statementsFactory.createBlock();
        block.setName("");
        result.setStatement((Statement)block);
        return result;
    }
}

