/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ClassResolver
extends AbstractResolverWithCache<Class, ITypeBinding> {
    private final ClassifiersFactory classifiersFactory;
    private final Set<ITypeBinding> typeBindings;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public ClassResolver(Map<String, Class> bindings, ClassifiersFactory classifiersFactory, Set<ITypeBinding> typeBindings, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter) {
        super(bindings);
        this.classifiersFactory = classifiersFactory;
        this.typeBindings = typeBindings;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public Class getByBinding(ITypeBinding binding) {
        this.typeBindings.add(binding);
        return this.getByName(this.toTypeNameConverter.convert(binding));
    }

    @Override
    public Class getByName(String name) {
        Class resultClass;
        if (this.containsKey(name)) {
            resultClass = (Class)this.get(name);
        } else {
            ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(name);
            Class result = potClass instanceof Class ? (Class)potClass : this.classifiersFactory.createClass();
            this.putBinding(name, result);
            resultClass = result;
        }
        return resultClass;
    }
}

