/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.Annotation;
import tools.mdsd.jamopp.model.java.classifiers.AnonymousClass;
import tools.mdsd.jamopp.model.java.classifiers.Class;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.model.java.generics.TypeParameter;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ClassifierResolver
implements Resolver<Classifier, ITypeBinding> {
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;
    private final ResolverWithCache<AnonymousClass, ITypeBinding> anonymousClassResolver;
    private final ResolverWithCache<Annotation, ITypeBinding> annotationResolver;
    private final ResolverWithCache<Interface, ITypeBinding> interfaceResolver;
    private final ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver;
    private final ResolverWithCache<Class, ITypeBinding> classResolver;
    private final ResolverWithCache<TypeParameter, ITypeBinding> typeParameterResolver;

    @Inject
    public ClassifierResolver(ResolverWithCache<AnonymousClass, ITypeBinding> anonymousClassResolver, ResolverWithCache<TypeParameter, ITypeBinding> typeParameterResolver, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter, ResolverWithCache<Interface, ITypeBinding> interfaceResolver, ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver, ResolverWithCache<Class, ITypeBinding> classResolver, ResolverWithCache<Annotation, ITypeBinding> annotationResolver) {
        this.anonymousClassResolver = anonymousClassResolver;
        this.toTypeNameConverter = toTypeNameConverter;
        this.annotationResolver = annotationResolver;
        this.interfaceResolver = interfaceResolver;
        this.enumerationResolver = enumerationResolver;
        this.classResolver = classResolver;
        this.typeParameterResolver = typeParameterResolver;
    }

    @Override
    public Classifier getByBinding(ITypeBinding binding) {
        String typeName = this.toTypeNameConverter.convert(binding);
        ConcreteClassifier classifier = null;
        ConcreteClassifier potClass = JavaClasspath.get().getConcreteClassifier(typeName);
        if (potClass != null) {
            classifier = potClass;
        } else if (!(binding.isAnonymous() || binding.isLocal() && binding.getDeclaringMember() == null || this.anonymousClassResolver.containsKey(this.toTypeNameConverter.convert(binding)))) {
            classifier = this.switchOverBinding(binding);
        }
        return classifier;
    }

    private Classifier switchOverBinding(ITypeBinding binding) {
        Classifier classifier = null;
        if (binding.isAnnotation()) {
            classifier = (Classifier)this.annotationResolver.getByBinding(binding);
        } else if (binding.isInterface()) {
            classifier = (Classifier)this.interfaceResolver.getByBinding(binding);
        } else if (binding.isEnum()) {
            classifier = (Classifier)this.enumerationResolver.getByBinding(binding);
        } else if (binding.isClass()) {
            classifier = (Classifier)this.classResolver.getByBinding(binding);
        } else if (binding.isTypeVariable()) {
            classifier = (Classifier)this.typeParameterResolver.getByBinding(binding);
        } else if (binding.isArray()) {
            classifier = this.getByBinding(binding.getElementType());
        }
        return classifier;
    }
}

