/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Constructor;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.statements.Block;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class ConstructorResolver
extends AbstractResolverWithCache<Constructor, IMethodBinding> {
    private final Set<IMethodBinding> methodBindings;
    private final StatementsFactory statementsFactory;
    private final MembersFactory membersFactory;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<IMethodBinding> toMethodNameConverter;
    private final ToStringConverter<ITypeBinding> toTypeNameConverterFromBinding;
    private final ToStringConverter<TypeReference> toTypeNameConverterFromReference;

    @Inject
    public ConstructorResolver(Map<String, Constructor> bindings, ToStringConverter<TypeReference> toTypeNameConverterFromReference, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverterFromBinding, ToStringConverter<IMethodBinding> toMethodNameConverter, StatementsFactory statementsFactory, Set<IMethodBinding> methodBindings, MembersFactory membersFactory, Resolver<Classifier, ITypeBinding> classifierResolver) {
        super(bindings);
        this.methodBindings = methodBindings;
        this.statementsFactory = statementsFactory;
        this.membersFactory = membersFactory;
        this.classifierResolver = classifierResolver;
        this.toMethodNameConverter = toMethodNameConverter;
        this.toTypeNameConverterFromBinding = toTypeNameConverterFromBinding;
        this.toTypeNameConverterFromReference = toTypeNameConverterFromReference;
    }

    @Override
    public Constructor getByBinding(IMethodBinding binding) {
        Constructor constructor;
        String methName = this.toMethodNameConverter.convert(binding);
        if (this.containsKey(methName)) {
            constructor = (Constructor)this.get(methName);
        } else {
            this.methodBindings.add(binding);
            Constructor result = this.getConstructor(binding);
            if (result == null) {
                result = this.membersFactory.createConstructor();
                Block block = this.statementsFactory.createBlock();
                block.setName("");
                result.setBlock(block);
            }
            this.putBinding(methName, result);
            constructor = result;
        }
        return constructor;
    }

    @Override
    public Constructor getByName(String name) {
        Constructor constructor;
        if (this.containsKey(name)) {
            constructor = (Constructor)this.get(name);
        } else {
            Constructor result = this.membersFactory.createConstructor();
            Block block = this.statementsFactory.createBlock();
            block.setName("");
            result.setBlock(block);
            this.putBinding(name, result);
            constructor = result;
        }
        return constructor;
    }

    /*
     * WARNING - void declaration
     */
    private Constructor getConstructor(IMethodBinding binding) {
        Constructor result = null;
        ConcreteClassifier potClass = (ConcreteClassifier)this.classifierResolver.getByBinding(binding.getDeclaringClass());
        if (potClass != null) {
            for (Member mem : potClass.getMembers()) {
                void con;
                Constructor constructor;
                Member member = mem;
                if (!(member instanceof Constructor) || (constructor = (Constructor)member) != (Constructor)member || !mem.getName().equals(binding.getName())) continue;
                int receiveOffset = 0;
                if (binding.getDeclaredReceiverType() != null) {
                    receiveOffset = 1;
                }
                if (con.getParameters().size() != binding.getParameterTypes().length + receiveOffset || this.shouldSkip(binding, (Constructor)con, receiveOffset)) continue;
                result = con;
                break;
            }
        }
        return result;
    }

    private boolean shouldSkip(IMethodBinding binding, Constructor con, int receiveOffset) {
        return receiveOffset == 1 && (!(con.getParameters().get(0) instanceof ReceiverParameter) || !this.toTypeNameConverterFromBinding.convert(binding.getDeclaredReceiverType()).equals(this.toTypeNameConverterFromReference.convert(((Parameter)con.getParameters().get(0)).getTypeReference()))) || this.skipMember(binding, con, receiveOffset);
    }

    private boolean skipMember(IMethodBinding binding, Constructor con, int receiveOffset) {
        boolean skipMember = false;
        int i = 0;
        while (i < binding.getParameterTypes().length) {
            ITypeBinding currentType = binding.getParameterTypes()[i];
            Parameter currentParam = (Parameter)con.getParameters().get(i + receiveOffset);
            if (!this.toTypeNameConverterFromBinding.convert(currentType).equals(this.toTypeNameConverterFromReference.convert(currentParam.getTypeReference())) || (long)currentType.getDimensions() != currentParam.getArrayDimension()) {
                skipMember = true;
                break;
            }
            ++i;
        }
        return skipMember;
    }
}

