/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.model.java.members.EnumConstant;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class EnumConstantResolver
extends AbstractResolverWithCache<EnumConstant, IVariableBinding> {
    private final MembersFactory membersFactory;
    private final Set<IVariableBinding> variableBindings;
    private final ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver;
    private final ToStringConverter<IVariableBinding> toFieldNameConverter;

    @Inject
    public EnumConstantResolver(Map<String, EnumConstant> bindings, Set<IVariableBinding> variableBindings, MembersFactory membersFactory, ResolverWithCache<Enumeration, ITypeBinding> enumerationResolver, ToStringConverter<IVariableBinding> toFieldNameConverter) {
        super(bindings);
        this.membersFactory = membersFactory;
        this.variableBindings = variableBindings;
        this.enumerationResolver = enumerationResolver;
        this.toFieldNameConverter = toFieldNameConverter;
    }

    @Override
    public EnumConstant getByBinding(IVariableBinding binding) {
        EnumConstant enumConstant;
        String enumCN = this.toFieldNameConverter.convert(binding);
        if (this.containsKey(enumCN)) {
            enumConstant = (EnumConstant)this.get(enumCN);
        } else {
            this.variableBindings.add(binding);
            Enumeration potPar = (Enumeration)this.enumerationResolver.getByBinding(binding.getDeclaringClass());
            EnumConstant result = null;
            if (potPar != null) {
                for (EnumConstant con : potPar.getConstants()) {
                    if (!con.getName().equals(binding.getName())) continue;
                    result = con;
                    break;
                }
            }
            if (result == null) {
                result = this.membersFactory.createEnumConstant();
            }
            this.putBinding(enumCN, result);
            enumConstant = result;
        }
        return enumConstant;
    }

    @Override
    public EnumConstant getByName(String name) {
        EnumConstant enumConstant;
        if (this.containsKey(name)) {
            enumConstant = (EnumConstant)this.get(name);
        } else {
            EnumConstant result = this.membersFactory.createEnumConstant();
            this.putBinding(name, result);
            enumConstant = result;
        }
        return enumConstant;
    }
}

