/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Enumeration;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class EnumerationResolver
extends AbstractResolverWithCache<Enumeration, ITypeBinding> {
    private final ClassifiersFactory classifiersFactory;
    private final Set<ITypeBinding> typeBindings;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public EnumerationResolver(Map<String, Enumeration> bindings, Set<ITypeBinding> typeBindings, ClassifiersFactory classifiersFactory, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter) {
        super(bindings);
        this.classifiersFactory = classifiersFactory;
        this.typeBindings = typeBindings;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public Enumeration getByBinding(ITypeBinding binding) {
        Enumeration enumeration;
        String enumName = this.toTypeNameConverter.convert(binding);
        if (this.containsKey(enumName)) {
            enumeration = (Enumeration)this.get(enumName);
        } else {
            this.typeBindings.add(binding);
            ConcreteClassifier classifier = JavaClasspath.get().getConcreteClassifier(enumName);
            Enumeration result = classifier instanceof Enumeration ? (Enumeration)classifier : this.classifiersFactory.createEnumeration();
            this.putBinding(enumName, result);
            enumeration = result;
        }
        return enumeration;
    }

    @Override
    public Enumeration getByName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

