/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.Field;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class FieldResolver
extends AbstractResolverWithCache<Field, IVariableBinding> {
    private final Set<IVariableBinding> variableBindings;
    private final TypesFactory typesFactory;
    private final MembersFactory membersFactory;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<IVariableBinding> toFieldNameConverter;

    @Inject
    public FieldResolver(Map<String, Field> bindings, Set<IVariableBinding> variableBindings, TypesFactory typesFactory, MembersFactory membersFactory, Resolver<Classifier, ITypeBinding> classifierResolver, ToStringConverter<IVariableBinding> toFieldNameConverter) {
        super(bindings);
        this.variableBindings = variableBindings;
        this.typesFactory = typesFactory;
        this.membersFactory = membersFactory;
        this.classifierResolver = classifierResolver;
        this.toFieldNameConverter = toFieldNameConverter;
    }

    @Override
    public Field getByBinding(IVariableBinding binding) {
        String varName = this.toFieldNameConverter.convert(binding);
        Field field = this.containsKey(varName) ? (Field)this.get(varName) : this.getByBinding(binding, varName);
        return field;
    }

    @Override
    public Field getByName(String name) {
        Field field;
        if (this.containsKey(name)) {
            field = (Field)this.get(name);
        } else {
            Field result = this.membersFactory.createField();
            this.putBinding(name, result);
            field = result;
        }
        return field;
    }

    private Field getByBinding(IVariableBinding binding, String varName) {
        this.variableBindings.add(binding);
        ConcreteClassifier potClass = null;
        if (binding.getDeclaringClass() != null) {
            potClass = (ConcreteClassifier)this.classifierResolver.getByBinding(binding.getDeclaringClass());
        }
        Field result = null;
        if (potClass != null) {
            for (Member mem : potClass.getMembers()) {
                if (!(mem instanceof Field) || !mem.getName().equals(binding.getName())) continue;
                result = (Field)mem;
                break;
            }
        }
        if (result == null) {
            result = this.membersFactory.createField();
            result.setTypeReference((TypeReference)this.typesFactory.createInt());
        }
        this.putBinding(varName, result);
        return result;
    }
}

