/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.classifiers.Classifier;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.members.InterfaceMethod;
import tools.mdsd.jamopp.model.java.members.Member;
import tools.mdsd.jamopp.model.java.members.MembersFactory;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.statements.Statement;
import tools.mdsd.jamopp.model.java.statements.StatementsFactory;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.model.java.types.TypesFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.MethodChecker;
import tools.mdsd.jamopp.parser.interfaces.resolver.Resolver;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class InterfaceMethodResolver
extends AbstractResolverWithCache<InterfaceMethod, IMethodBinding> {
    private final Set<IMethodBinding> methodBindings;
    private final StatementsFactory statementsFactory;
    private final TypesFactory typesFactory;
    private final MembersFactory membersFactory;
    private final MethodChecker methodCheckerImpl;
    private final Resolver<Classifier, ITypeBinding> classifierResolver;
    private final ToStringConverter<IMethodBinding> toMethodNameConverter;

    @Inject
    public InterfaceMethodResolver(Map<String, InterfaceMethod> bindings, TypesFactory typesFactory, StatementsFactory statementsFactory, Set<IMethodBinding> methodBindings, MembersFactory membersFactory, Resolver<Classifier, ITypeBinding> classifierResolver, MethodChecker methodCheckerImpl, ToStringConverter<IMethodBinding> toMethodNameConverter) {
        super(bindings);
        this.statementsFactory = statementsFactory;
        this.typesFactory = typesFactory;
        this.membersFactory = membersFactory;
        this.methodBindings = methodBindings;
        this.classifierResolver = classifierResolver;
        this.methodCheckerImpl = methodCheckerImpl;
        this.toMethodNameConverter = toMethodNameConverter;
    }

    @Override
    public InterfaceMethod getByBinding(IMethodBinding binding) {
        InterfaceMethod interfaceMethod;
        IMethodBinding methoDeclaration = binding.getMethodDeclaration();
        this.methodBindings.add(methoDeclaration);
        String methName = this.toMethodNameConverter.convert(methoDeclaration);
        if (this.containsKey(methName)) {
            interfaceMethod = (InterfaceMethod)this.get(methName);
        } else {
            ConcreteClassifier classifier = (ConcreteClassifier)this.classifierResolver.getByBinding(methoDeclaration.getDeclaringClass());
            InterfaceMethod result = null;
            if (classifier != null) {
                result = this.handleNullClassifier(methoDeclaration, classifier);
            }
            if (result == null) {
                result = this.createNewInterfaceMethod();
            }
            this.putBinding(methName, result);
            interfaceMethod = result;
        }
        return interfaceMethod;
    }

    private InterfaceMethod handleNullClassifier(IMethodBinding methoDeclaration, ConcreteClassifier classifier) {
        InterfaceMethod interfaceMethod = null;
        for (Member mem : classifier.getMembers()) {
            if (mem instanceof InterfaceMethod && (interfaceMethod = (InterfaceMethod)this.methodCheckerImpl.checkMethod((Method)mem, methoDeclaration)) != null) break;
        }
        return interfaceMethod;
    }

    @Override
    public InterfaceMethod getByName(String name) {
        InterfaceMethod interfaceMethod;
        if (this.containsKey(name)) {
            interfaceMethod = (InterfaceMethod)this.get(name);
        } else {
            InterfaceMethod result = this.createNewInterfaceMethod();
            this.putBinding(name, result);
            interfaceMethod = result;
        }
        return interfaceMethod;
    }

    private InterfaceMethod createNewInterfaceMethod() {
        InterfaceMethod result = this.membersFactory.createInterfaceMethod();
        result.setTypeReference((TypeReference)this.typesFactory.createVoid());
        result.setStatement((Statement)this.statementsFactory.createEmptyStatement());
        return result;
    }
}

