/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.model.java.classifiers.ClassifiersFactory;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.classifiers.Interface;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class InterfaceResolver
extends AbstractResolverWithCache<Interface, ITypeBinding> {
    private final ClassifiersFactory classifiersFactory;
    private final Set<ITypeBinding> typeBindings;
    private final ToStringConverter<ITypeBinding> toTypeNameConverter;

    @Inject
    public InterfaceResolver(Map<String, Interface> bindings, Set<ITypeBinding> typeBindings, ClassifiersFactory classifiersFactory, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverter) {
        super(bindings);
        this.classifiersFactory = classifiersFactory;
        this.typeBindings = typeBindings;
        this.toTypeNameConverter = toTypeNameConverter;
    }

    @Override
    public Interface getByBinding(ITypeBinding binding) {
        Interface interfaceResult;
        String interName = this.toTypeNameConverter.convert(binding);
        if (this.containsKey(interName)) {
            interfaceResult = (Interface)this.get(interName);
        } else {
            this.typeBindings.add(binding);
            ConcreteClassifier classifier = JavaClasspath.get().getConcreteClassifier(interName);
            Interface result = classifier instanceof Interface ? (Interface)classifier : this.classifiersFactory.createInterface();
            this.putBinding(interName, result);
            interfaceResult = result;
        }
        return interfaceResult;
    }

    @Override
    public Interface getByName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

