/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.IVariableBinding;
import tools.mdsd.jamopp.model.java.variables.LocalVariable;
import tools.mdsd.jamopp.model.java.variables.VariablesFactory;
import tools.mdsd.jamopp.parser.implementation.resolver.AbstractResolverWithCache;
import tools.mdsd.jamopp.parser.interfaces.resolver.ConverterWithBoolean;

public class LocalVariableResolver
extends AbstractResolverWithCache<LocalVariable, IVariableBinding> {
    private final VariablesFactory variablesFactory;
    private final Set<IVariableBinding> variableBindings;
    private final ConverterWithBoolean<IVariableBinding> toParameterNameConverter;

    @Inject
    public LocalVariableResolver(Map<String, LocalVariable> bindings, VariablesFactory variablesFactory, Set<IVariableBinding> variableBindings, ConverterWithBoolean<IVariableBinding> toParameterNameConverter) {
        super(bindings);
        this.variablesFactory = variablesFactory;
        this.variableBindings = variableBindings;
        this.toParameterNameConverter = toParameterNameConverter;
    }

    @Override
    public LocalVariable getByBinding(IVariableBinding binding) {
        this.variableBindings.add(binding);
        return this.getByName(this.toParameterNameConverter.convertToParameterName(binding, true));
    }

    @Override
    public LocalVariable getByName(String name) {
        LocalVariable localVariable;
        if (this.containsKey(name)) {
            localVariable = (LocalVariable)this.get(name);
        } else {
            LocalVariable result = this.variablesFactory.createLocalVariable();
            this.putBinding(name, result);
            localVariable = result;
        }
        return localVariable;
    }
}

