/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.jamopp.parser.implementation.resolver;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.parameters.Parameter;
import tools.mdsd.jamopp.model.java.parameters.Parametrizable;
import tools.mdsd.jamopp.model.java.parameters.ReceiverParameter;
import tools.mdsd.jamopp.model.java.types.TypeReference;
import tools.mdsd.jamopp.parser.interfaces.resolver.MethodChecker;
import tools.mdsd.jamopp.parser.interfaces.resolver.ToStringConverter;

public class MethodCheckerImpl
implements MethodChecker {
    private final ToStringConverter<ITypeBinding> toTypeNameConverterFromBinding;
    private final ToStringConverter<TypeReference> toTypeNameConverterFromReference;

    @Inject
    public MethodCheckerImpl(ToStringConverter<TypeReference> toTypeNameConverterFromReference, @Named(value="ToTypeNameConverterFromBinding") ToStringConverter<ITypeBinding> toTypeNameConverterFromBinding) {
        this.toTypeNameConverterFromBinding = toTypeNameConverterFromBinding;
        this.toTypeNameConverterFromReference = toTypeNameConverterFromReference;
    }

    @Override
    public <T extends Method> T checkMethod(Method mem, IMethodBinding binding) {
        Method result = null;
        if (mem.getName().equals(binding.getName())) {
            Method meth = mem;
            if ("clone".equals(meth.getName())) {
                result = meth;
            } else {
                int receiveOffset = 0;
                if (binding.getDeclaredReceiverType() != null) {
                    receiveOffset = 1;
                }
                if (binding.getParameterTypes().length + receiveOffset == meth.getParameters().size() && !this.predicateOne(binding, meth, receiveOffset) && !this.predicateThree(binding, (Parametrizable)mem, receiveOffset)) {
                    result = meth;
                }
            }
        }
        return (T)result;
    }

    private boolean predicateThree(IMethodBinding binding, Parametrizable meth, int receiveOffset) {
        boolean result = false;
        int i = 0;
        while (i < binding.getParameterTypes().length) {
            Parameter currentParam;
            ITypeBinding currentParamType = binding.getParameterTypes()[i];
            if (this.predicateTwo(currentParamType, currentParam = (Parameter)meth.getParameters().get(i + receiveOffset))) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private boolean predicateTwo(ITypeBinding currentParamType, Parameter currentParam) {
        return !this.toTypeNameConverterFromBinding.convert(currentParamType).equals(this.toTypeNameConverterFromReference.convert(currentParam.getTypeReference())) || (long)currentParamType.getDimensions() != currentParam.getArrayDimension();
    }

    private <T extends Method> boolean predicateOne(IMethodBinding binding, T meth, int receiveOffset) {
        return receiveOffset == 1 && (!(meth.getParameters().get(0) instanceof ReceiverParameter) || !this.toTypeNameConverterFromBinding.convert(binding.getDeclaredReceiverType()).equals(this.toTypeNameConverterFromReference.convert(((Parameter)meth.getParameters().get(0)).getTypeReference()))) || !this.toTypeNameConverterFromBinding.convert(binding.getReturnType()).equals(this.toTypeNameConverterFromReference.convert(meth.getTypeReference()));
    }
}

